/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DatanodeCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeCacheManager.class);
    private final StoragePolicySatisfier.DatanodeMap datanodeMap;
    private NetworkTopology cluster;
    private final long refreshIntervalMs;
    private long lastAccessedTime;

    public DatanodeCacheManager(Configuration conf) {
        this.refreshIntervalMs = conf.getLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 300000L);
        LOG.info("DatanodeCacheManager refresh interval is {} milliseconds", (Object)this.refreshIntervalMs);
        this.datanodeMap = new StoragePolicySatisfier.DatanodeMap();
    }

    public StoragePolicySatisfier.DatanodeMap getLiveDatanodeStorageReport(Context spsContext) throws IOException {
        long now = Time.monotonicNow();
        long elapsedTimeMs = now - this.lastAccessedTime;
        boolean refreshNeeded = elapsedTimeMs >= this.refreshIntervalMs;
        this.lastAccessedTime = now;
        if (refreshNeeded) {
            DatanodeStorageReport[] liveDns;
            if (LOG.isDebugEnabled()) {
                LOG.debug("elapsedTimeMs > refreshIntervalMs : {} > {}, so refreshing cache", (Object)elapsedTimeMs, (Object)this.refreshIntervalMs);
            }
            this.datanodeMap.reset();
            for (DatanodeStorageReport storage : liveDns = spsContext.getLiveDatanodeStorageReport()) {
                StorageReport[] storageReports = storage.getStorageReports();
                ArrayList<StorageType> storageTypes = new ArrayList<StorageType>();
                ArrayList<Long> remainingSizeList = new ArrayList<Long>();
                for (StorageReport t : storageReports) {
                    if (t.getRemaining() <= 0L) continue;
                    storageTypes.add(t.getStorage().getStorageType());
                    remainingSizeList.add(t.getRemaining());
                }
                this.datanodeMap.addTarget(storage.getDatanodeInfo(), storageTypes, remainingSizeList);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("LIVE datanodes: {}", (Object)this.datanodeMap);
            }
            this.cluster = spsContext.getNetworkTopology(this.datanodeMap);
        }
        return this.datanodeMap;
    }

    NetworkTopology getCluster() {
        return this.cluster;
    }
}

