/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.hash.Hash;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BloomMapFile {
    private static final Logger LOG = LoggerFactory.getLogger(BloomMapFile.class);
    public static final String BLOOM_FILE_NAME = "bloom";
    public static final int HASH_COUNT = 5;

    public static void delete(FileSystem fs, String name) throws IOException {
        Path dir = new Path(name);
        Path data = new Path(dir, "data");
        Path index = new Path(dir, "index");
        Path bloom = new Path(dir, BLOOM_FILE_NAME);
        fs.delete(data, true);
        fs.delete(index, true);
        fs.delete(bloom, true);
        fs.delete(dir, true);
    }

    private static byte[] byteArrayForBloomKey(DataOutputBuffer buf) {
        byte[] ba;
        int cleanLength = buf.getLength();
        if (cleanLength != (ba = buf.getData()).length) {
            ba = new byte[cleanLength];
            System.arraycopy(buf.getData(), 0, ba, 0, cleanLength);
        }
        return ba;
    }

    public static class Reader
    extends MapFile.Reader {
        private DynamicBloomFilter bloomFilter;
        private DataOutputBuffer buf = new DataOutputBuffer();
        private Key bloomKey = new Key();

        public Reader(Path dir, Configuration conf, SequenceFile.Reader.Option ... options) throws IOException {
            super(dir, conf, options);
            this.initBloomFilter(dir, conf);
        }

        @Deprecated
        public Reader(FileSystem fs, String dirName, Configuration conf) throws IOException {
            this(new Path(dirName), conf, new SequenceFile.Reader.Option[0]);
        }

        @Deprecated
        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf, boolean open) throws IOException {
            this(new Path(dirName), conf, Reader.comparator(comparator));
        }

        @Deprecated
        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf) throws IOException {
            this(new Path(dirName), conf, Reader.comparator(comparator));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initBloomFilter(Path dirName, Configuration conf) {
            FSDataInputStream in = null;
            try {
                FileSystem fs = dirName.getFileSystem(conf);
                in = fs.open(new Path(dirName, BloomMapFile.BLOOM_FILE_NAME));
                this.bloomFilter = new DynamicBloomFilter();
                this.bloomFilter.readFields(in);
                in.close();
                in = null;
            }
            catch (IOException ioe) {
                try {
                    LOG.warn("Can't open BloomFilter: " + ioe + " - fallback to MapFile.");
                    this.bloomFilter = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(in);
                    throw throwable;
                }
                IOUtils.closeStream(in);
            }
            IOUtils.closeStream(in);
        }

        public boolean probablyHasKey(WritableComparable key) throws IOException {
            if (this.bloomFilter == null) {
                return true;
            }
            this.buf.reset();
            key.write(this.buf);
            this.bloomKey.set(BloomMapFile.byteArrayForBloomKey(this.buf), 1.0);
            return this.bloomFilter.membershipTest(this.bloomKey);
        }

        @Override
        public synchronized Writable get(WritableComparable key, Writable val) throws IOException {
            if (!this.probablyHasKey(key)) {
                return null;
            }
            return super.get(key, val);
        }

        public Filter getBloomFilter() {
            return this.bloomFilter;
        }
    }

    public static class Writer
    extends MapFile.Writer {
        private DynamicBloomFilter bloomFilter;
        private int numKeys;
        private int vectorSize;
        private Key bloomKey = new Key();
        private DataOutputBuffer buf = new DataOutputBuffer();
        private FileSystem fs;
        private Path dir;

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class<? extends Writable> valClass, SequenceFile.CompressionType compress, CompressionCodec codec, Progressable progress) throws IOException {
            this(conf, new Path(dirName), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compress, codec), Writer.progressable(progress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass, SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            this(conf, new Path(dirName), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compress), Writer.progressable(progress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass, SequenceFile.CompressionType compress) throws IOException {
            this(conf, new Path(dirName), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, SequenceFile.CompressionType compress, CompressionCodec codec, Progressable progress) throws IOException {
            this(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(valClass), Writer.compression(compress, codec), Writer.progressable(progress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            this(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(valClass), Writer.compression(compress), Writer.progressable(progress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, SequenceFile.CompressionType compress) throws IOException {
            this(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(valClass), Writer.compression(compress));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass) throws IOException {
            this(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(valClass));
        }

        @Deprecated
        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass) throws IOException {
            this(conf, new Path(dirName), Writer.keyClass(keyClass), Writer.valueClass(valClass));
        }

        public Writer(Configuration conf, Path dir, SequenceFile.Writer.Option ... options) throws IOException {
            super(conf, dir, options);
            this.fs = dir.getFileSystem(conf);
            this.dir = dir;
            this.initBloomFilter(conf);
        }

        private synchronized void initBloomFilter(Configuration conf) {
            this.numKeys = conf.getInt("io.mapfile.bloom.size", 0x100000);
            float errorRate = conf.getFloat("io.mapfile.bloom.error.rate", 0.005f);
            this.vectorSize = (int)Math.ceil((double)(-5 * this.numKeys) / Math.log(1.0 - Math.pow(errorRate, 0.2)));
            this.bloomFilter = new DynamicBloomFilter(this.vectorSize, 5, Hash.getHashType(conf), this.numKeys);
        }

        @Override
        public synchronized void append(WritableComparable key, Writable val) throws IOException {
            super.append(key, val);
            this.buf.reset();
            key.write(this.buf);
            this.bloomKey.set(BloomMapFile.byteArrayForBloomKey(this.buf), 1.0);
            this.bloomFilter.add(this.bloomKey);
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
            FSDataOutputStream out = this.fs.create(new Path(this.dir, BloomMapFile.BLOOM_FILE_NAME), true);
            try {
                this.bloomFilter.write(out);
                out.flush();
                ((FilterOutputStream)out).close();
                out = null;
            }
            finally {
                IOUtils.closeStream(out);
            }
        }
    }
}

