/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class DelegationTokenAuthenticator
implements Authenticator {
    private static Logger LOG = LoggerFactory.getLogger(DelegationTokenAuthenticator.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON_MIME = "application/json";
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    public static final String OP_PARAM = "op";
    private static final String OP_PARAM_EQUALS = "op=";
    public static final String DELEGATION_TOKEN_HEADER = "X-Hadoop-Delegation-Token";
    public static final String DELEGATION_PARAM = "delegation";
    public static final String TOKEN_PARAM = "token";
    public static final String RENEWER_PARAM = "renewer";
    public static final String SERVICE_PARAM = "service";
    public static final String DELEGATION_TOKEN_JSON = "Token";
    public static final String DELEGATION_TOKEN_URL_STRING_JSON = "urlString";
    public static final String RENEW_DELEGATION_TOKEN_JSON = "long";
    private Authenticator authenticator;
    private ConnectionConfigurator connConfigurator;

    public DelegationTokenAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.authenticator.setConnectionConfigurator(configurator);
        this.connConfigurator = configurator;
    }

    private boolean hasDelegationToken(URL url, AuthenticatedURL.Token token) {
        boolean hasDt = false;
        if (token instanceof DelegationTokenAuthenticatedURL.Token) {
            boolean bl = hasDt = ((DelegationTokenAuthenticatedURL.Token)token).getDelegationToken() != null;
            if (hasDt) {
                LOG.trace("Delegation token found: {}", (Object)((DelegationTokenAuthenticatedURL.Token)token).getDelegationToken());
            }
        }
        if (!hasDt) {
            String queryStr = url.getQuery();
            hasDt = queryStr != null && queryStr.contains("delegation=");
            LOG.trace("hasDt={}, queryStr={}", (Object)hasDt, (Object)queryStr);
        }
        return hasDt;
    }

    @Override
    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!this.hasDelegationToken(url, token)) {
            try {
                UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                LOG.debug("No delegation token found for url={}, token={}, authenticating with {}", url, token, this.authenticator.getClass());
                this.authenticator.authenticate(url, token);
            }
            catch (IOException ex) {
                throw NetUtils.wrapException(url.getHost(), url.getPort(), null, 0, ex);
            }
        } else {
            LOG.debug("Authenticated from delegation token. url={}, token={}", (Object)url, (Object)token);
        }
    }

    public Token<AbstractDelegationTokenIdentifier> getDelegationToken(URL url, AuthenticatedURL.Token token, String renewer) throws IOException, AuthenticationException {
        return this.getDelegationToken(url, token, renewer, null);
    }

    public Token<AbstractDelegationTokenIdentifier> getDelegationToken(URL url, AuthenticatedURL.Token token, String renewer, String doAsUser) throws IOException, AuthenticationException {
        Map json = this.doDelegationTokenOperation(url, token, DelegationTokenOperation.GETDELEGATIONTOKEN, renewer, null, true, doAsUser);
        json = (Map)json.get(DELEGATION_TOKEN_JSON);
        String tokenStr = (String)json.get(DELEGATION_TOKEN_URL_STRING_JSON);
        Token<AbstractDelegationTokenIdentifier> dToken = new Token<AbstractDelegationTokenIdentifier>();
        dToken.decodeFromUrlString(tokenStr);
        InetSocketAddress service = new InetSocketAddress(url.getHost(), url.getPort());
        SecurityUtil.setTokenService(dToken, service);
        return dToken;
    }

    public long renewDelegationToken(URL url, AuthenticatedURL.Token token, Token<AbstractDelegationTokenIdentifier> dToken) throws IOException, AuthenticationException {
        return this.renewDelegationToken(url, token, dToken, null);
    }

    public long renewDelegationToken(URL url, AuthenticatedURL.Token token, Token<AbstractDelegationTokenIdentifier> dToken, String doAsUser) throws IOException, AuthenticationException {
        Map json = this.doDelegationTokenOperation(url, token, DelegationTokenOperation.RENEWDELEGATIONTOKEN, null, dToken, true, doAsUser);
        return (Long)json.get(RENEW_DELEGATION_TOKEN_JSON);
    }

    public void cancelDelegationToken(URL url, AuthenticatedURL.Token token, Token<AbstractDelegationTokenIdentifier> dToken) throws IOException {
        this.cancelDelegationToken(url, token, dToken, null);
    }

    public void cancelDelegationToken(URL url, AuthenticatedURL.Token token, Token<AbstractDelegationTokenIdentifier> dToken, String doAsUser) throws IOException {
        try {
            this.doDelegationTokenOperation(url, token, DelegationTokenOperation.CANCELDELEGATIONTOKEN, null, dToken, false, doAsUser);
        }
        catch (AuthenticationException ex) {
            throw new IOException("This should not happen: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map doDelegationTokenOperation(URL url, AuthenticatedURL.Token token, DelegationTokenOperation operation, String renewer, Token<?> dToken, boolean hasResponse, String doAsUser) throws IOException, AuthenticationException {
        Map ret;
        block12: {
            ret = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(OP_PARAM, operation.toString());
            if (renewer != null) {
                params.put(RENEWER_PARAM, renewer);
            }
            if (dToken != null) {
                params.put(TOKEN_PARAM, dToken.encodeToUrlString());
            }
            if (doAsUser != null) {
                params.put("doAs", URLEncoder.encode(doAsUser, "UTF-8"));
            }
            String urlStr = url.toExternalForm();
            StringBuilder sb = new StringBuilder(urlStr);
            String separator = urlStr.contains("?") ? "&" : "?";
            for (Map.Entry entry : params.entrySet()) {
                sb.append(separator).append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF8"));
                separator = "&";
            }
            url = new URL(sb.toString());
            AuthenticatedURL aUrl = new AuthenticatedURL(this, this.connConfigurator);
            Token<AbstractDelegationTokenIdentifier> dt = null;
            if (token instanceof DelegationTokenAuthenticatedURL.Token && operation.requiresKerberosCredentials()) {
                dt = ((DelegationTokenAuthenticatedURL.Token)token).getDelegationToken();
                ((DelegationTokenAuthenticatedURL.Token)token).setDelegationToken(null);
            }
            try {
                HttpURLConnection conn = aUrl.openConnection(url, token);
                conn.setRequestMethod(operation.getHttpMethod());
                HttpExceptionUtils.validateResponse(conn, 200);
                if (!hasResponse) break block12;
                String contentType = conn.getHeaderField(CONTENT_TYPE);
                String string = contentType = contentType != null ? StringUtils.toLowerCase(contentType) : null;
                if (contentType != null && contentType.contains(APPLICATION_JSON_MIME)) {
                    try {
                        ret = (Map)JsonSerialization.mapReader().readValue(conn.getInputStream());
                        break block12;
                    }
                    catch (Exception ex) {
                        throw new AuthenticationException(String.format("'%s' did not handle the '%s' delegation token operation: %s", new Object[]{url.getAuthority(), operation, ex.getMessage()}), ex);
                    }
                }
                throw new AuthenticationException(String.format("'%s' did not respond with JSON to the '%s' delegation token operation", new Object[]{url.getAuthority(), operation}));
            }
            finally {
                if (dt != null) {
                    ((DelegationTokenAuthenticatedURL.Token)token).setDelegationToken(dt);
                }
            }
        }
        return ret;
    }

    @InterfaceAudience.Private
    public static enum DelegationTokenOperation {
        GETDELEGATIONTOKEN("GET", true),
        RENEWDELEGATIONTOKEN("PUT", true),
        CANCELDELEGATIONTOKEN("PUT", false);

        private String httpMethod;
        private boolean requiresKerberosCredentials;

        private DelegationTokenOperation(String httpMethod, boolean requiresKerberosCredentials) {
            this.httpMethod = httpMethod;
            this.requiresKerberosCredentials = requiresKerberosCredentials;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public boolean requiresKerberosCredentials() {
            return this.requiresKerberosCredentials;
        }
    }
}

