/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonFactory;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.JsonUtilities;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StorageRequest;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.CloudTableClient;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

final class TableStorageErrorDeserializer {
    TableStorageErrorDeserializer() {
    }

    public static StorageExtendedErrorInformation parseErrorDetails(StorageRequest<CloudTableClient, ?, ?> request) {
        try {
            if (request == null || request.getConnection().getErrorStream() == null) {
                return null;
            }
            return TableStorageErrorDeserializer.getExtendedErrorInformation(new InputStreamReader(request.getConnection().getErrorStream()), TablePayloadFormat.Json);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageExtendedErrorInformation getExtendedErrorInformation(Reader reader, TablePayloadFormat format) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = jsonFactory.createParser(reader);
        try {
            StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            JsonUtilities.assertIsFieldNameJsonToken(parser);
            JsonUtilities.assertIsExpectedFieldName(parser, "odata.error");
            parser.nextToken();
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextValue();
            JsonUtilities.assertIsExpectedFieldName(parser, "code");
            errorInfo.setErrorCode(parser.getValueAsString());
            parser.nextToken();
            JsonUtilities.assertIsFieldNameJsonToken(parser);
            JsonUtilities.assertIsExpectedFieldName(parser, "message");
            parser.nextToken();
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextValue();
            JsonUtilities.assertIsExpectedFieldName(parser, "lang");
            parser.nextValue();
            JsonUtilities.assertIsExpectedFieldName(parser, "value");
            errorInfo.setErrorMessage(parser.getValueAsString());
            parser.nextToken();
            JsonUtilities.assertIsEndObjectJsonToken(parser);
            parser.nextToken();
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                JsonUtilities.assertIsExpectedFieldName(parser, "innererror");
                errorInfo.getAdditionalDetails().putAll(TableStorageErrorDeserializer.parseJsonErrorException(parser));
                parser.nextToken();
            }
            JsonUtilities.assertIsEndObjectJsonToken(parser);
            parser.nextToken();
            JsonUtilities.assertIsEndObjectJsonToken(parser);
            StorageExtendedErrorInformation storageExtendedErrorInformation = errorInfo;
            return storageExtendedErrorInformation;
        }
        finally {
            parser.close();
        }
    }

    private static HashMap<String, String[]> parseJsonErrorException(JsonParser parser) throws JsonParseException, IOException {
        HashMap<String, String[]> additionalDetails = new HashMap<String, String[]>();
        parser.nextToken();
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        JsonUtilities.assertIsFieldNameJsonToken(parser);
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentName().equals("message")) {
                parser.nextToken();
                additionalDetails.put("message", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("type")) {
                parser.nextToken();
                additionalDetails.put("type", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("stacktrace")) {
                parser.nextToken();
                additionalDetails.put("StackTrace", new String[]{parser.getValueAsString()});
            }
            parser.nextToken();
        }
        return additionalDetails;
    }
}

