/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.squareup.okhttp;

import io.prestosql.hadoop.$internal.com.squareup.okhttp.Address;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.Internal;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.RouteDatabase;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.Util;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.StreamAllocation;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.io.RealConnection;
import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final long DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final ConnectionPool systemDefault;
    private final Executor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private Runnable cleanupRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long waitNanos;
            while ((waitNanos = ConnectionPool.this.cleanup(System.nanoTime())) != -1L) {
                if (waitNanos <= 0L) continue;
                long waitMillis = waitNanos / 1000000L;
                waitNanos -= waitMillis * 1000000L;
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    try {
                        ConnectionPool.this.wait(waitMillis, (int)waitNanos);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    };
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    final RouteDatabase routeDatabase = new RouteDatabase();

    public ConnectionPool(int maxIdleConnections, long keepAliveDurationMs) {
        this(maxIdleConnections, keepAliveDurationMs, TimeUnit.MILLISECONDS);
    }

    public ConnectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        if (keepAliveDuration <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration <= 0: " + keepAliveDuration);
        }
    }

    public static ConnectionPool getDefault() {
        return systemDefault;
    }

    public synchronized int getIdleConnectionCount() {
        int total = 0;
        for (RealConnection connection : this.connections) {
            if (!connection.allocations.isEmpty()) continue;
            ++total;
        }
        return total;
    }

    public synchronized int getConnectionCount() {
        return this.connections.size();
    }

    @Deprecated
    public synchronized int getSpdyConnectionCount() {
        return this.getMultiplexedConnectionCount();
    }

    public synchronized int getMultiplexedConnectionCount() {
        int total = 0;
        for (RealConnection connection : this.connections) {
            if (!connection.isMultiplexed()) continue;
            ++total;
        }
        return total;
    }

    public synchronized int getHttpConnectionCount() {
        return this.connections.size() - this.getMultiplexedConnectionCount();
    }

    RealConnection get(Address address, StreamAllocation streamAllocation) {
        assert (Thread.holdsLock(this));
        for (RealConnection connection : this.connections) {
            if (connection.allocations.size() >= connection.allocationLimit() || !address.equals(connection.getRoute().address) || connection.noNewStreams) continue;
            streamAllocation.acquire(connection);
            return connection;
        }
        return null;
    }

    void put(RealConnection connection) {
        assert (Thread.holdsLock(this));
        if (this.connections.isEmpty()) {
            this.executor.execute(this.cleanupRunnable);
        }
        this.connections.add(connection);
    }

    boolean connectionBecameIdle(RealConnection connection) {
        assert (Thread.holdsLock(this));
        if (connection.noNewStreams || this.maxIdleConnections == 0) {
            this.connections.remove(connection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<RealConnection> evictedConnections = new ArrayList<RealConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator<RealConnection> i = this.connections.iterator();
            while (i.hasNext()) {
                RealConnection connection = i.next();
                if (!connection.allocations.isEmpty()) continue;
                connection.noNewStreams = true;
                evictedConnections.add(connection);
                i.remove();
            }
        }
        for (RealConnection connection : evictedConnections) {
            Util.closeQuietly(connection.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long cleanup(long now) {
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (RealConnection connection : this.connections) {
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    ++inUseConnectionCount;
                    continue;
                }
                ++idleConnectionCount;
                long idleDurationNs = now - connection.idleAtNanos;
                if (idleDurationNs <= longestIdleDurationNs) continue;
                longestIdleDurationNs = idleDurationNs;
                longestIdleConnection = connection;
            }
            if (longestIdleDurationNs < this.keepAliveDurationNs && idleConnectionCount <= this.maxIdleConnections) {
                if (idleConnectionCount > 0) {
                    return this.keepAliveDurationNs - longestIdleDurationNs;
                }
                if (inUseConnectionCount > 0) {
                    return this.keepAliveDurationNs;
                }
                return -1L;
            }
            this.connections.remove(longestIdleConnection);
        }
        Util.closeQuietly(longestIdleConnection.getSocket());
        return 0L;
    }

    private int pruneAndGetAllocationCount(RealConnection connection, long now) {
        List<Reference<StreamAllocation>> references = connection.allocations;
        int i = 0;
        while (i < references.size()) {
            Reference<StreamAllocation> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Internal.logger.warning("A connection to " + connection.getRoute().getAddress().url() + " was leaked. Did you forget to close a response body?");
            references.remove(i);
            connection.noNewStreams = true;
            if (!references.isEmpty()) continue;
            connection.idleAtNanos = now - this.keepAliveDurationNs;
            return 0;
        }
        return references.size();
    }

    void setCleanupRunnableForTest(Runnable cleanupRunnable) {
        this.cleanupRunnable = cleanupRunnable;
    }

    static {
        long keepAliveDurationMs;
        String keepAlive = System.getProperty("http.keepAlive");
        String keepAliveDuration = System.getProperty("http.keepAliveDuration");
        String maxIdleConnections = System.getProperty("http.maxConnections");
        long l = keepAliveDurationMs = keepAliveDuration != null ? Long.parseLong(keepAliveDuration) : 300000L;
        systemDefault = keepAlive != null && !Boolean.parseBoolean(keepAlive) ? new ConnectionPool(0, keepAliveDurationMs) : (maxIdleConnections != null ? new ConnectionPool(Integer.parseInt(maxIdleConnections), keepAliveDurationMs) : new ConnectionPool(5, keepAliveDurationMs));
    }
}

