/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.configuration2.interpol;

import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.interpol.DefaultLookups;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.interpol.DummyLookup;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.interpol.Lookup;
import io.prestosql.hadoop.$internal.org.apache.commons.lang3.text.StrLookup;
import io.prestosql.hadoop.$internal.org.apache.commons.lang3.text.StrSubstitutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigurationInterpolator {
    private static final char PREFIX_SEPARATOR = ':';
    private static final String VAR_START = "${";
    private static final String VAR_END = "}";
    private static final Map<String, Lookup> DEFAULT_PREFIX_LOOKUPS;
    private final Map<String, Lookup> prefixLookups = new ConcurrentHashMap<String, Lookup>();
    private final List<Lookup> defaultLookups = new CopyOnWriteArrayList<Lookup>();
    private final StrSubstitutor substitutor = this.initSubstitutor();
    private volatile ConfigurationInterpolator parentInterpolator;

    public static ConfigurationInterpolator fromSpecification(InterpolatorSpecification spec) {
        if (spec == null) {
            throw new IllegalArgumentException("InterpolatorSpecification must not be null!");
        }
        return spec.getInterpolator() != null ? spec.getInterpolator() : ConfigurationInterpolator.createInterpolator(spec);
    }

    public static Map<String, Lookup> getDefaultPrefixLookups() {
        return DEFAULT_PREFIX_LOOKUPS;
    }

    public static Lookup nullSafeLookup(Lookup lookup) {
        if (lookup == null) {
            lookup = DummyLookup.INSTANCE;
        }
        return lookup;
    }

    public Map<String, Lookup> getLookups() {
        return new HashMap<String, Lookup>(this.prefixLookups);
    }

    public void registerLookup(String prefix, Lookup lookup) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.prefixLookups.put(prefix, lookup);
    }

    public void registerLookups(Map<String, ? extends Lookup> lookups) {
        if (lookups != null) {
            this.prefixLookups.putAll(lookups);
        }
    }

    public boolean deregisterLookup(String prefix) {
        return this.prefixLookups.remove(prefix) != null;
    }

    public Set<String> prefixSet() {
        return Collections.unmodifiableSet(this.prefixLookups.keySet());
    }

    public List<Lookup> getDefaultLookups() {
        return new ArrayList<Lookup>(this.defaultLookups);
    }

    public void addDefaultLookup(Lookup defaultLookup) {
        this.defaultLookups.add(defaultLookup);
    }

    public void addDefaultLookups(Collection<? extends Lookup> lookups) {
        if (lookups != null) {
            this.defaultLookups.addAll(lookups);
        }
    }

    public boolean removeDefaultLookup(Lookup lookup) {
        return this.defaultLookups.remove(lookup);
    }

    public void setParentInterpolator(ConfigurationInterpolator parentInterpolator) {
        this.parentInterpolator = parentInterpolator;
    }

    public ConfigurationInterpolator getParentInterpolator() {
        return this.parentInterpolator;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.substitutor.isEnableSubstitutionInVariables();
    }

    public void setEnableSubstitutionInVariables(boolean f) {
        this.substitutor.setEnableSubstitutionInVariables(f);
    }

    public Object interpolate(Object value) {
        if (value instanceof String) {
            Object resolvedValue;
            String strValue = (String)value;
            if (ConfigurationInterpolator.looksLikeSingleVariable(strValue) && (resolvedValue = this.resolveSingleVariable(strValue)) != null && !(resolvedValue instanceof String)) {
                return resolvedValue;
            }
            return this.substitutor.replace(strValue);
        }
        return value;
    }

    public Object resolve(String var) {
        Object value;
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos);
            String name = var.substring(prefixPos + 1);
            value = this.fetchLookupForPrefix(prefix).lookup(name);
            if (value != null) {
                return value;
            }
        }
        for (Lookup l : this.defaultLookups) {
            value = l.lookup(var);
            if (value == null) continue;
            return value;
        }
        ConfigurationInterpolator parent = this.getParentInterpolator();
        if (parent != null) {
            return this.getParentInterpolator().resolve(var);
        }
        return null;
    }

    protected Lookup fetchLookupForPrefix(String prefix) {
        return ConfigurationInterpolator.nullSafeLookup(this.prefixLookups.get(prefix));
    }

    private StrSubstitutor initSubstitutor() {
        return new StrSubstitutor(new StrLookup<Object>(){

            @Override
            public String lookup(String key) {
                Object result = ConfigurationInterpolator.this.resolve(key);
                return result != null ? result.toString() : null;
            }
        });
    }

    private Object resolveSingleVariable(String strValue) {
        return this.resolve(ConfigurationInterpolator.extractVariableName(strValue));
    }

    private static boolean looksLikeSingleVariable(String strValue) {
        return strValue.startsWith(VAR_START) && strValue.endsWith(VAR_END);
    }

    private static String extractVariableName(String strValue) {
        return strValue.substring(VAR_START.length(), strValue.length() - VAR_END.length());
    }

    private static ConfigurationInterpolator createInterpolator(InterpolatorSpecification spec) {
        ConfigurationInterpolator ci = new ConfigurationInterpolator();
        ci.addDefaultLookups(spec.getDefaultLookups());
        ci.registerLookups(spec.getPrefixLookups());
        ci.setParentInterpolator(spec.getParentInterpolator());
        return ci;
    }

    static {
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        for (DefaultLookups l : DefaultLookups.values()) {
            lookups.put(l.getPrefix(), l.getLookup());
        }
        DEFAULT_PREFIX_LOOKUPS = Collections.unmodifiableMap(lookups);
    }
}

