/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.jaas;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class TokenJaasKrbUtil {
    public static Subject loginUsingToken(String principal, File tokenCache, File armorCache, File ccache, File signKeyFile) throws LoginException {
        Subject subject = new Subject(false, new HashSet(), new HashSet(), new HashSet());
        Configuration conf = TokenJaasKrbUtil.useTokenCache(principal, tokenCache, armorCache, ccache, signKeyFile);
        String confName = "TokenCacheConf";
        LoginContext loginContext = new LoginContext(confName, subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Subject loginUsingToken(String principal, String tokenStr, File armorCache, File ccache, File signKeyFile) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = TokenJaasKrbUtil.useTokenStr(principal, tokenStr, armorCache, ccache, signKeyFile);
        String confName = "TokenStrConf";
        LoginContext loginContext = new LoginContext(confName, subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    private static Configuration useTokenCache(String principal, File tokenCache, File armorCache, File tgtCache, File signKeyFile) {
        return new TokenJaasConf(principal, tokenCache, armorCache, tgtCache, signKeyFile);
    }

    private static Configuration useTokenStr(String principal, String tokenStr, File armorCache, File tgtCache, File signKeyFile) {
        return new TokenJaasConf(principal, tokenStr, armorCache, tgtCache, signKeyFile);
    }

    static class TokenJaasConf
    extends Configuration {
        private String principal;
        private File tokenCache;
        private String tokenStr;
        private File armorCache;
        private File ccache;
        private File signKeyFile;

        TokenJaasConf(String principal, File tokenCache, File armorCache, File ccache, File signKeyFile) {
            this.principal = principal;
            this.tokenCache = tokenCache;
            this.armorCache = armorCache;
            this.ccache = ccache;
            this.signKeyFile = signKeyFile;
        }

        TokenJaasConf(String principal, String tokenStr, File armorCache, File ccache, File signKeyFile) {
            this.principal = principal;
            this.tokenStr = tokenStr;
            this.armorCache = armorCache;
            this.ccache = ccache;
            this.signKeyFile = signKeyFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            if (this.tokenCache != null) {
                options.put("tokenCache", this.tokenCache.getAbsolutePath());
            } else if (this.tokenStr != null) {
                options.put("token", this.tokenStr);
            }
            options.put("armorCache", this.armorCache.getAbsolutePath());
            if (this.ccache != null) {
                options.put("credentialCache", this.ccache.getAbsolutePath());
            }
            if (this.signKeyFile != null) {
                options.put("signKeyFile", this.signKeyFile.getAbsolutePath());
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.jaas.TokenAuthLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

