/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.token;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.kerby.KOption;
import io.prestosql.hadoop.$internal.org.apache.kerby.KOptions;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.TokenOption;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.token.TokenContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.token.TokenRequestContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PaFlag;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.token.TokenPreauthMeta;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.token.PaTokenRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.token.TokenInfo;
import java.util.Collections;
import java.util.List;

public class TokenPreauth
extends AbstractPreauthPlugin {
    private TokenContext tokenContext;

    public TokenPreauth() {
        super(new TokenPreauthMeta());
    }

    @Override
    public void init(KrbContext context) {
        super.init(context);
        this.tokenContext = new TokenContext();
    }

    @Override
    public .PluginRequestContext initRequestContext(KdcRequest kdcRequest) {
        TokenRequestContext reqCtx = new TokenRequestContext();
        return reqCtx;
    }

    @Override
    public void prepareQuestions(KdcRequest kdcRequest, .PluginRequestContext requestContext) {
    }

    @Override
    public List<EncryptionType> getEncTypes(KdcRequest kdcRequest, .PluginRequestContext requestContext) {
        return Collections.emptyList();
    }

    @Override
    public void setPreauthOptions(KdcRequest kdcRequest, .PluginRequestContext requestContext, KOptions options) {
        this.tokenContext.usingIdToken = options.getBooleanOption(TokenOption.USE_TOKEN, false);
        if (this.tokenContext.usingIdToken) {
            if (options.contains(TokenOption.USER_ID_TOKEN)) {
                this.tokenContext.token = (AuthToken)options.getOptionValue(TokenOption.USER_ID_TOKEN);
            }
        } else if (options.contains(TokenOption.USER_AC_TOKEN)) {
            this.tokenContext.token = (AuthToken)options.getOptionValue(TokenOption.USER_AC_TOKEN);
        }
    }

    @Override
    public void tryFirst(KdcRequest kdcRequest, .PluginRequestContext requestContext, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
    }

    @Override
    public boolean process(KdcRequest kdcRequest, .PluginRequestContext requestContext, PaDataEntry inPadata, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
        return true;
    }

    @Override
    public boolean tryAgain(KdcRequest kdcRequest, .PluginRequestContext requestContext, PaDataType preauthType, PaData errPadata, PaData outPadata) {
        return false;
    }

    @Override
    public PaFlags getFlags(PaDataType paType) {
        PaFlags paFlags = new PaFlags(0);
        paFlags.setFlag(PaFlag.PA_REAL);
        return paFlags;
    }

    private PaDataEntry makeEntry(KdcRequest kdcRequest) throws KrbException {
        KrbToken krbToken;
        KOptions options = kdcRequest.getPreauthOptions();
        KOption idToken = options.getOption(TokenOption.USER_ID_TOKEN);
        KOption acToken = options.getOption(TokenOption.USER_AC_TOKEN);
        if (idToken != null) {
            krbToken = (KrbToken)idToken.getOptionInfo().getValue();
        } else if (acToken != null) {
            krbToken = (KrbToken)acToken.getOptionInfo().getValue();
        } else {
            throw new KrbException("missing token.");
        }
        PaTokenRequest tokenPa = new PaTokenRequest();
        tokenPa.setToken(krbToken);
        TokenInfo info = new TokenInfo();
        info.setTokenVendor(krbToken.getIssuer());
        tokenPa.setTokenInfo(info);
        EncryptedData paDataValue = EncryptionUtil.seal(tokenPa, kdcRequest.getAsKey(), KeyUsage.PA_TOKEN);
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.TOKEN_REQUEST);
        paDataEntry.setPaDataValue(KrbCodec.encode(paDataValue));
        return paDataEntry;
    }
}

