/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;

public class HdfsDtFetcher
implements DtFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsDtFetcher.class);
    private static final String SERVICE_NAME = "hdfs";
    private static final String FETCH_FAILED = "Fetch of delegation token failed";

    @Override
    public Text getServiceName() {
        return new Text(SERVICE_NAME);
    }

    @Override
    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        FileSystem fs;
        Token<?> token;
        if (!url.startsWith(this.getServiceName().toString())) {
            url = this.getServiceName().toString() + "://" + url;
        }
        if ((token = (fs = FileSystem.get(URI.create(url), conf)).getDelegationToken(renewer)) == null) {
            LOG.error(FETCH_FAILED);
            throw new IOException(FETCH_FAILED);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

