/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import io.prestosql.hadoop.$internal.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.common.BlockAlias;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FileRegion
implements BlockAlias {
    private final Pair<Block, ProvidedStorageLocation> pair;

    public FileRegion(long blockId, Path path, long offset, long length, long genStamp) {
        this(blockId, path, offset, length, genStamp, new byte[0]);
    }

    public FileRegion(long blockId, Path path, long offset, long length, long genStamp, byte[] nonce) {
        this(new Block(blockId, length, genStamp), new ProvidedStorageLocation(path, offset, length, nonce));
    }

    public FileRegion(long blockId, Path path, long offset, long length) {
        this(blockId, path, offset, length, 0L);
    }

    public FileRegion(Block block, ProvidedStorageLocation providedStorageLocation) {
        this.pair = Pair.of(block, providedStorageLocation);
    }

    @Override
    public Block getBlock() {
        return this.pair.getKey();
    }

    public ProvidedStorageLocation getProvidedStorageLocation() {
        return this.pair.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRegion that = (FileRegion)o;
        return this.pair.equals(that.pair);
    }

    public int hashCode() {
        return this.pair.hashCode();
    }
}

