/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.com.google.common.collect.ImmutableMap;
import io.prestosql.hadoop.$internal.com.google.common.collect.Maps;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.util.Daemon;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataNodeDiskMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(DataNodeDiskMetrics.class);
    private DataNode dn;
    private final long MIN_OUTLIER_DETECTION_DISKS = 5L;
    private final long SLOW_DISK_LOW_THRESHOLD_MS = 20L;
    private final long detectionInterval;
    private volatile boolean shouldRun;
    private OutlierDetector slowDiskDetector;
    private Daemon slowDiskDetectionDaemon;
    private volatile Map<String, Map<SlowDiskReports.DiskOp, Double>> diskOutliersStats = Maps.newHashMap();

    public DataNodeDiskMetrics(DataNode dn, long diskOutlierDetectionIntervalMs) {
        this.dn = dn;
        this.detectionInterval = diskOutlierDetectionIntervalMs;
        this.slowDiskDetector = new OutlierDetector(5L, 20L);
        this.shouldRun = true;
        this.startDiskOutlierDetectionThread();
    }

    private void startDiskOutlierDetectionThread() {
        this.slowDiskDetectionDaemon = new Daemon(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (DataNodeDiskMetrics.this.shouldRun) {
                    HashMap<String, Double> metadataOpStats = Maps.newHashMap();
                    HashMap<String, Double> readIoStats = Maps.newHashMap();
                    HashMap<String, Double> writeIoStats = Maps.newHashMap();
                    FsDatasetSpi.FsVolumeReferences fsVolumeReferences = null;
                    try {
                        fsVolumeReferences = DataNodeDiskMetrics.this.dn.getFSDataset().getFsVolumeReferences();
                        Iterator<FsVolumeSpi> volumeIterator = fsVolumeReferences.iterator();
                        while (volumeIterator.hasNext()) {
                            FsVolumeSpi volume = volumeIterator.next();
                            DataNodeVolumeMetrics metrics = volumeIterator.next().getMetrics();
                            String volumeName = volume.getBaseURI().getPath();
                            metadataOpStats.put(volumeName, metrics.getMetadataOperationMean());
                            readIoStats.put(volumeName, metrics.getReadIoMean());
                            writeIoStats.put(volumeName, metrics.getWriteIoMean());
                        }
                    }
                    finally {
                        if (fsVolumeReferences != null) {
                            try {
                                fsVolumeReferences.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error in releasing FS Volume references", e);
                            }
                        }
                    }
                    if (metadataOpStats.isEmpty() && readIoStats.isEmpty() && writeIoStats.isEmpty()) {
                        LOG.debug("No disk stats available for detecting outliers.");
                        return;
                    }
                    DataNodeDiskMetrics.this.detectAndUpdateDiskOutliers(metadataOpStats, readIoStats, writeIoStats);
                    try {
                        Thread.sleep(DataNodeDiskMetrics.this.detectionInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Disk Outlier Detection thread interrupted", e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.slowDiskDetectionDaemon.start();
    }

    private void detectAndUpdateDiskOutliers(Map<String, Double> metadataOpStats, Map<String, Double> readIoStats, Map<String, Double> writeIoStats) {
        HashMap<String, Map<SlowDiskReports.DiskOp, Double>> diskStats = Maps.newHashMap();
        Map<String, Double> metadataOpOutliers = this.slowDiskDetector.getOutliers(metadataOpStats);
        for (Map.Entry<String, Double> entry : metadataOpOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.METADATA, entry.getValue());
        }
        Map<String, Double> readIoOutliers = this.slowDiskDetector.getOutliers(readIoStats);
        for (Map.Entry<String, Double> entry : readIoOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.READ, entry.getValue());
        }
        Map<String, Double> map = this.slowDiskDetector.getOutliers(writeIoStats);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.WRITE, entry.getValue());
        }
        this.diskOutliersStats = diskStats;
        LOG.debug("Updated disk outliers.");
    }

    private void addDiskStat(Map<String, Map<SlowDiskReports.DiskOp, Double>> diskStats, String disk, SlowDiskReports.DiskOp diskOp, double latency) {
        if (!diskStats.containsKey(disk)) {
            diskStats.put(disk, new HashMap());
        }
        diskStats.get(disk).put(diskOp, latency);
    }

    public Map<String, Map<SlowDiskReports.DiskOp, Double>> getDiskOutliersStats() {
        return this.diskOutliersStats;
    }

    public void shutdownAndWait() {
        this.shouldRun = false;
        this.slowDiskDetectionDaemon.interrupt();
        try {
            this.slowDiskDetectionDaemon.join();
        }
        catch (InterruptedException e) {
            LOG.error("Disk Outlier Detection daemon did not shutdown", e);
        }
    }

    @VisibleForTesting
    public void addSlowDiskForTesting(String slowDiskPath, Map<SlowDiskReports.DiskOp, Double> latencies) {
        if (latencies == null) {
            this.diskOutliersStats.put(slowDiskPath, ImmutableMap.of());
        } else {
            this.diskOutliersStats.put(slowDiskPath, latencies);
        }
    }
}

