/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.util.LongBitFormat;

public enum XAttrFormat implements LongBitFormat.Enum
{
    RESERVED(null, 5),
    NS_EXT(XAttrFormat.RESERVED.BITS, 1),
    NAME(XAttrFormat.NS_EXT.BITS, 24),
    NS(XAttrFormat.NAME.BITS, 2);

    private static final int NS_EXT_SHIFT;
    private static final int NS_MASK;
    private static final int XATTR_VALUE_LEN_MAX = 65536;
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES;
    private final LongBitFormat BITS;

    private XAttrFormat(LongBitFormat previous, int length) {
        this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
    }

    @Override
    public int getLength() {
        return this.BITS.getLength();
    }

    static XAttr.NameSpace getNamespace(int record) {
        long nid = XAttrFormat.NS.BITS.retrieve(record);
        return XATTR_NAMESPACE_VALUES[(int)(nid |= XAttrFormat.NS_EXT.BITS.retrieve(record) << NS_EXT_SHIFT)];
    }

    public static String getName(int record) {
        int nid = (int)XAttrFormat.NAME.BITS.retrieve(record);
        return SerialNumberManager.XATTR.getString(nid);
    }

    static int toInt(XAttr a) {
        int nid = SerialNumberManager.XATTR.getSerialNumber(a.getName());
        int nsOrd = a.getNameSpace().ordinal();
        long value = XAttrFormat.NS.BITS.combine(nsOrd & NS_MASK, 0L);
        value = XAttrFormat.NS_EXT.BITS.combine(nsOrd >>> NS_EXT_SHIFT, value);
        value = XAttrFormat.NAME.BITS.combine(nid, value);
        return (int)value;
    }

    static XAttr toXAttr(int record, byte[] value, SerialNumberManager.StringTable stringTable) {
        int nid = (int)XAttrFormat.NAME.BITS.retrieve(record);
        String name = SerialNumberManager.XATTR.getString(nid, stringTable);
        return new XAttr.Builder().setNameSpace(XAttrFormat.getNamespace(record)).setName(name).setValue(value).build();
    }

    static List<XAttr> toXAttrs(byte[] attrs) {
        ArrayList<XAttr> xAttrs = new ArrayList<XAttr>();
        if (attrs == null || attrs.length == 0) {
            return xAttrs;
        }
        int i = 0;
        while (i < attrs.length) {
            XAttr.Builder builder = new XAttr.Builder();
            int v = Ints.fromBytes(attrs[i], attrs[i + 1], attrs[i + 2], attrs[i + 3]);
            builder.setNameSpace(XAttrFormat.getNamespace(v));
            builder.setName(XAttrFormat.getName(v));
            int vlen = (0xFF & attrs[i += 4]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                builder.setValue(value);
                i += vlen;
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    static XAttr getXAttr(byte[] attrs, String prefixedName) {
        int vlen;
        if (prefixedName == null || attrs == null) {
            return null;
        }
        XAttr xAttr = XAttrHelper.buildXAttr(prefixedName);
        for (int i = 0; i < attrs.length; i += vlen) {
            int v = Ints.fromBytes(attrs[i], attrs[i + 1], attrs[i + 2], attrs[i + 3]);
            XAttr.NameSpace namespace = XAttrFormat.getNamespace(v);
            String name = XAttrFormat.getName(v);
            vlen = (0xFF & attrs[i += 4]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (xAttr.getNameSpace() != namespace || !xAttr.getName().equals(name)) continue;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                return new XAttr.Builder().setNameSpace(namespace).setName(name).setValue(value).build();
            }
            return xAttr;
        }
        return null;
    }

    static byte[] toBytes(List<XAttr> xAttrs) {
        if (xAttrs == null || xAttrs.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (XAttr a : xAttrs) {
                int v = XAttrFormat.toInt(a);
                out.write(Ints.toByteArray(v));
                int vlen = a.getValue() == null ? 0 : a.getValue().length;
                Preconditions.checkArgument(vlen < 65536, "The length of xAttr values is too long.");
                out.write((byte)(vlen >> 8));
                out.write((byte)vlen);
                if (vlen <= 0) continue;
                out.write(a.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    static {
        NS_EXT_SHIFT = XAttrFormat.NS.BITS.getLength();
        NS_MASK = (1 << NS_EXT_SHIFT) - 1;
        XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();
    }
}

