/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;

class CallReturn {
    static final CallReturn ASYNC_CALL_IN_PROGRESS = new CallReturn(State.ASYNC_CALL_IN_PROGRESS);
    static final CallReturn ASYNC_INVOKED = new CallReturn(State.ASYNC_INVOKED);
    static final CallReturn RETRY = new CallReturn(State.RETRY);
    static final CallReturn WAIT_RETRY = new CallReturn(State.WAIT_RETRY);
    private final Object returnValue;
    private final Throwable thrown;
    private final State state;

    CallReturn(Object r) {
        this(r, null, State.RETURNED);
    }

    CallReturn(Throwable t) {
        this(null, t, State.EXCEPTION);
        Preconditions.checkNotNull(t);
    }

    private CallReturn(State s) {
        this(null, null, s);
    }

    private CallReturn(Object r, Throwable t, State s) {
        Preconditions.checkArgument(r == null || t == null);
        this.returnValue = r;
        this.thrown = t;
        this.state = s;
    }

    State getState() {
        return this.state;
    }

    Object getReturnValue() throws Throwable {
        if (this.state == State.EXCEPTION) {
            throw this.thrown;
        }
        Preconditions.checkState(this.state == State.RETURNED, "state == %s", new Object[]{this.state});
        return this.returnValue;
    }

    static enum State {
        RETURNED,
        EXCEPTION,
        RETRY,
        WAIT_RETRY,
        ASYNC_CALL_IN_PROGRESS,
        ASYNC_INVOKED;

    }
}

