/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum CharColumnMapper implements ResultColumnMapper<Character>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private CharColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Character mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        return this.charFromString(r.getString(columnNumber));
    }

    @Override
    public Character mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        return this.charFromString(r.getString(columnLabel));
    }

    public Character charFromString(String s) {
        if (s != null && !s.isEmpty()) {
            return Character.valueOf(s.charAt(0));
        }
        if (this.nullable) {
            return null;
        }
        return Character.valueOf('\u0000');
    }
}

