/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public class RuntimeStatsCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeStatsCleanerTask.class);
    private Configuration conf;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.RUNTIME_STATS_CLEAN_FREQUENCY, unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        try {
            RawStore ms = HiveMetaStore.HMSHandler.getMSForConf(this.conf);
            int maxRetainSecs = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.RUNTIME_STATS_MAX_AGE, TimeUnit.SECONDS);
            int deleteCnt = ms.deleteRuntimeStats(maxRetainSecs);
            if ((long)deleteCnt > 0L) {
                LOG.info("Number of deleted entries: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete: " + e.getMessage(), e);
        }
    }
}

