/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import io.prestosql.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;

public class VectorMapJoinFastLongHashSet
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashSet {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashSet.class);

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastHashSet.HashSetResult();
    }

    @VisibleForTesting
    public void testPutRow(long currentKey) throws HiveException, IOException {
        this.add(currentKey, null);
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = 1L;
            this.slotPairs[pairIndex + 1] = key;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(long key, VectorMapJoinHashSetResult hashSetResult) {
        VectorMapJoinFastHashSet.HashSetResult optimizedHashSetResult = (VectorMapJoinFastHashSet.HashSetResult)hashSetResult;
        optimizedHashSetResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode(key);
        long existance = this.findReadSlot(key, hashCode);
        JoinUtil.JoinResult joinResult = existance == -1L ? JoinUtil.JoinResult.NOMATCH : JoinUtil.JoinResult.MATCH;
        optimizedHashSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastLongHashSet(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(minMaxEnabled, isOuterJoin, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
    }

    @Override
    public long getEstimatedMemorySize() {
        return super.getEstimatedMemorySize();
    }
}

