/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.ZoneId;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReaderFactory;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.Type;

public abstract class BaseVectorizedColumnReader
implements VectorizedColumnReader {
    private static final Logger LOG = LoggerFactory.getLogger(BaseVectorizedColumnReader.class);
    protected boolean skipTimestampConversion = false;
    protected ZoneId writerTimezone = null;
    protected long valuesRead;
    protected long endOfPageValueCount;
    protected final ParquetDataColumnReader dictionary;
    protected boolean isCurrentPageDictionaryEncoded;
    protected final int maxDefLevel;
    protected int definitionLevel;
    protected int repetitionLevel;
    protected IntIterator repetitionLevelColumn;
    protected IntIterator definitionLevelColumn;
    protected ParquetDataColumnReader dataColumn;
    protected int pageValueCount;
    protected final PageReader pageReader;
    protected final ColumnDescriptor descriptor;
    protected final Type type;
    protected final TypeInfo hiveType;

    public BaseVectorizedColumnReader() {
        this.pageReader = null;
        this.descriptor = null;
        this.type = null;
        this.dictionary = null;
        this.hiveType = null;
        this.maxDefLevel = -1;
    }

    public BaseVectorizedColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean skipTimestampConversion, ZoneId writerTimezone, Type parquetType, TypeInfo hiveType) throws IOException {
        this.descriptor = descriptor;
        this.type = parquetType;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.skipTimestampConversion = skipTimestampConversion;
        this.writerTimezone = writerTimezone;
        this.hiveType = hiveType;
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = ParquetDataColumnReaderFactory.getDataColumnReaderByTypeOnDictionary(parquetType.asPrimitiveType(), hiveType, dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage), skipTimestampConversion, writerTimezone);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    protected void readRepetitionAndDefinitionLevels() {
        this.repetitionLevel = this.repetitionLevelColumn.nextInt();
        this.definitionLevel = this.definitionLevelColumn.nextInt();
        ++this.valuesRead;
    }

    protected void readPage() throws IOException {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return;
        }
        page.accept(new DataPage.Visitor<Void>(){

            @Override
            public Void visit(DataPageV1 dataPageV1) {
                BaseVectorizedColumnReader.this.readPageV1(dataPageV1);
                return null;
            }

            @Override
            public Void visit(DataPageV2 dataPageV2) {
                BaseVectorizedColumnReader.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) throws IOException {
        this.pageValueCount = valueCount;
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(this.type.asPrimitiveType(), this.hiveType, dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary.getDictionary()), this.skipTimestampConversion, this.writerTimezone);
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = ParquetDataColumnReaderFactory.getDataColumnReaderByType(this.type.asPrimitiveType(), this.hiveType, dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES), this.skipTimestampConversion, this.writerTimezone);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
    }

    private void readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        try {
            BytesInput bytes = page.getBytes();
            LOG.debug("page size " + bytes.size() + " bytes and " + this.pageValueCount + " records");
            ByteBufferInputStream in = bytes.toInputStream();
            LOG.debug("reading repetition levels at " + in.position());
            rlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("reading definition levels at " + in.position());
            dlReader.initFromPage(this.pageValueCount, in);
            LOG.debug("reading data at " + in.position());
            this.initDataReader(page.getValueEncoding(), in, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void readPageV2(DataPageV2 page) {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            LOG.debug("page data size " + page.getData().size() + " bytes and " + this.pageValueCount + " records");
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream(), page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt(maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read levels in page for col " + this.descriptor, e);
        }
    }

    protected void decimalTypeCheck(Type type) {
        DecimalMetadata decimalMetadata = type.asPrimitiveType().getDecimalMetadata();
        if (decimalMetadata == null) {
            throw new UnsupportedOperationException("The underlying Parquet type cannot be able to converted to Hive Decimal type: " + type);
        }
    }

    protected static final class NullIntIterator
    extends IntIterator {
        protected NullIntIterator() {
        }

        @Override
        int nextInt() {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    extends IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }

    protected static final class ValuesReaderIntIterator
    extends IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static abstract class IntIterator {
        IntIterator() {
        }

        abstract int nextInt();
    }
}

