/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.truncate;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class ColumnTruncateMapper
extends MapReduceBase
implements Mapper<Object, RCFileValueBufferWrapper, Object, Object> {
    private JobConf jc;
    Class<? extends Writable> outputClass;
    RCFile.Writer outWriter;
    Path finalPath;
    FileSystem fs;
    boolean exception = false;
    boolean autoDelete = false;
    Path outPath;
    CompressionCodec codec = null;
    int columnNumber = 0;
    boolean tmpPathFixedConcatenate = false;
    boolean tmpPathFixed = false;
    Path tmpPath;
    Path taskTmpPath;
    Path dpPath;
    ColumnTruncateWork work;
    private static final Logger LOG = LoggerFactory.getLogger(ColumnTruncateMapper.class.getName());
    public static String BACKUP_PREFIX = "_backup.";

    public void configure(JobConf job) {
        this.jc = job;
        this.work = (ColumnTruncateWork)Utilities.getMapWork((Configuration)job);
        Path specPath = this.work.getOutputDir();
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        this.updatePaths(tmpPath, taskTmpPath);
        try {
            this.fs = specPath.getFileSystem((Configuration)job);
            this.autoDelete = this.fs.deleteOnExit(this.outPath);
        }
        catch (IOException e) {
            this.exception = true;
            throw new RuntimeException(e);
        }
    }

    private void updatePaths(Path tmpPath, Path taskTmpPath) {
        String taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tmpPath;
        this.taskTmpPath = taskTmpPath;
        String inputFile = this.jc.get("mapreduce.map.input.file");
        int lastSeparator = inputFile.lastIndexOf("/") + 1;
        this.finalPath = new Path(tmpPath, inputFile.substring(lastSeparator));
        this.outPath = new Path(taskTmpPath, Utilities.toTempPath(taskId));
    }

    public void map(Object k, RCFileValueBufferWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            RCFileKeyBufferWrapper key = null;
            key = k instanceof CombineHiveKey ? (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey() : (RCFileKeyBufferWrapper)k;
            if (this.work.getListBucketingCtx().calculateListBucketingLevel() > 0 && !this.tmpPathFixedConcatenate) {
                this.fixTmpPathConcatenate(key.getInputPath().getParent(), this.work.getListBucketingCtx().calculateListBucketingLevel());
                this.tmpPathFixedConcatenate = true;
            }
            if (this.outWriter == null) {
                this.codec = key.getCodec();
                this.columnNumber = key.getKeyBuffer().getColumnNumber();
                RCFileOutputFormat.setColumnNumber((Configuration)this.jc, this.columnNumber);
                this.outWriter = new RCFile.Writer(this.fs, (Configuration)this.jc, this.outPath, null, this.codec);
            }
            for (Integer i : this.work.getDroppedColumns()) {
                key.getKeyBuffer().nullColumn(i);
                value.getValueBuffer().nullColumn(i);
            }
            int keyLength = key.getKeyBuffer().getSize();
            int recordLength = key.getKeyBuffer().getSize();
            for (int columnLen : key.getKeyBuffer().getEachColumnValueLen()) {
                recordLength += columnLen;
            }
            this.outWriter.flushBlock(key.getKeyBuffer(), value.getValueBuffer(), recordLength, keyLength, key.getCompressedKeyLength());
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    private void fixTmpPathConcatenate(Path inputPath, int listBucketingDepth) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        for (int depth = listBucketingDepth; inputPath != null && depth > 0; inputPath = inputPath.getParent(), --depth) {
            newPath = new Path(inputPath.getName(), newPath);
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    public void close() throws IOException {
        if (this.outWriter == null) {
            return;
        }
        this.outWriter.close();
        this.outWriter = null;
        if (!this.exception) {
            FileStatus fss = this.fs.getFileStatus(this.outPath);
            LOG.info("renamed path " + this.outPath + " to " + this.finalPath + " . File size is " + fss.getLen());
            if (!this.fs.rename(this.outPath, this.finalPath)) {
                throw new IOException("Unable to rename output to " + this.finalPath);
            }
        } else if (!this.autoDelete) {
            this.fs.delete(this.outPath, true);
        }
    }

    public static Path backupOutputPath(FileSystem fs, Path outpath, JobConf job) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    public static void jobClose(Path outputPath, boolean success, JobConf job, SessionState.LogHelper console, DynamicPartitionCtx dynPartCtx, Reporter reporter) throws HiveException, IOException {
        FileSystem fs = outputPath.getFileSystem((Configuration)job);
        Path backupPath = ColumnTruncateMapper.backupOutputPath(fs, outputPath, job);
        Utilities.mvFileToFinalPath(outputPath, (Configuration)job, success, LOG, dynPartCtx, null, reporter);
        if (backupPath != null) {
            fs.delete(backupPath, true);
        }
    }
}

