/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import io.prestosql.hive.$internal.com.google.common.base.Joiner;
import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import io.prestosql.hive.$internal.com.google.common.math.LongMath;
import io.prestosql.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.AnnotationUtils;

public class StatsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StatsUtils.class.getName());

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, ColumnStatsList colStatsCache, Table table, TableScanOperator tableScanOperator) throws HiveException {
        ArrayList<ColumnInfo> schema = tableScanOperator.getSchema().getSignature();
        List<String> neededColumns = tableScanOperator.getNeededColumns();
        List<String> referencedColumns = tableScanOperator.getReferencedColumns();
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns);
    }

    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns) throws HiveException {
        boolean fetchColStats = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean testMode = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_IN_TEST);
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns, fetchColStats, testMode);
    }

    private static long getDataSize(HiveConf conf, Table table) {
        long ds = StatsUtils.getRawDataSize(table);
        if (ds <= 0L) {
            ds = StatsUtils.getTotalSize(table);
            if (ds <= 0L) {
                ds = StatsUtils.getFileSizeForTable(conf, table);
            }
            float deserFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
            ds = (long)((float)ds * deserFactor);
        }
        return ds;
    }

    public static long getNumRows(HiveConf conf, List<ColumnInfo> schema, Table table, PrunedPartitionList partitionList, AtomicInteger noColsMissingStats) {
        int avgRowSize;
        boolean shouldEstimateStats = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS);
        if (!table.isPartitioned()) {
            long nr = StatsUtils.getNumRows(table);
            if (nr <= 0L) {
                noColsMissingStats.getAndIncrement();
            }
            if (nr > 0L || !shouldEstimateStats) {
                return nr;
            }
            long ds = StatsUtils.getDataSize(conf, table);
            return StatsUtils.getNumRows(conf, schema, table, ds);
        }
        long nr = 0L;
        List<Object> rowCounts = Lists.newArrayList();
        rowCounts = StatsUtils.getBasicStatForPartitions(table, partitionList.getNotDeniedPartns(), "numRows");
        nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
        if (nr <= 0L) {
            noColsMissingStats.getAndIncrement();
        }
        if (nr > 0L || !shouldEstimateStats) {
            return nr;
        }
        long ds = 0L;
        ArrayList<Long> dataSizes = Lists.newArrayList();
        dataSizes = StatsUtils.getBasicStatForPartitions(table, partitionList.getNotDeniedPartns(), "rawDataSize");
        ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
        float deserFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        if (ds <= 0L) {
            dataSizes = StatsUtils.getBasicStatForPartitions(table, partitionList.getNotDeniedPartns(), "totalSize");
            dataSizes = StatsUtils.safeMult(dataSizes, deserFactor);
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
        }
        if (ds <= 0L && shouldEstimateStats) {
            dataSizes = StatsUtils.getFileSizeForPartitions(conf, partitionList.getNotDeniedPartns());
            dataSizes = StatsUtils.safeMult(dataSizes, deserFactor);
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
        }
        if ((avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema)) > 0) {
            StatsUtils.setUnknownRcDsToAverage(rowCounts, dataSizes, avgRowSize);
            nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            if (nr <= 0L) {
                nr = ds / (long)avgRowSize;
            }
        }
        if (nr == 0L) {
            nr = 1L;
        }
        return nr;
    }

    private static void estimateStatsForMissingCols(List<String> neededColumns, List<ColStatistics> columnStats, Table table, HiveConf conf, long nr, List<ColumnInfo> schema) {
        HashSet<String> neededCols = new HashSet<String>(neededColumns);
        HashSet<String> colsWithStats = new HashSet<String>();
        for (ColStatistics cstats : columnStats) {
            colsWithStats.add(cstats.getColumnName());
        }
        ArrayList<String> missingColStats = new ArrayList<String>(Sets.difference(neededCols, colsWithStats));
        if (missingColStats.size() > 0) {
            List<ColStatistics> estimatedColStats = StatsUtils.estimateStats(table, schema, missingColStats, conf, nr);
            for (ColStatistics estColStats : estimatedColStats) {
                columnStats.add(estColStats);
            }
        }
    }

    private static long getNumRows(HiveConf conf, List<ColumnInfo> schema, Table table, long ds) {
        int avgRowSize;
        long nr = StatsUtils.getNumRows(table);
        if (nr < 0L && (avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema)) > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Estimated average row size: " + avgRowSize);
            }
            nr = ds / (long)avgRowSize;
        }
        if (nr == 0L || nr == -1L) {
            return 1L;
        }
        return nr;
    }

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns, boolean fetchColStats) throws HiveException {
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, colStatsCache, referencedColumns, fetchColStats, false);
    }

    /*
     * WARNING - void declaration
     */
    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache, List<String> referencedColumns, boolean fetchColStats, boolean failIfCacheMiss) throws HiveException {
        Statistics stats = null;
        float deserFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        boolean shouldEstimateStats = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS);
        if (!table.isPartitioned()) {
            long ds = shouldEstimateStats ? StatsUtils.getDataSize(conf, table) : StatsUtils.getRawDataSize(table);
            long nr = StatsUtils.getNumRows(conf, schema, table, ds);
            List<Object> colStats = Lists.newArrayList();
            if (fetchColStats) {
                colStats = StatsUtils.getTableColumnStats(table, schema, neededColumns, colStatsCache);
                if (colStats == null) {
                    colStats = Lists.newArrayList();
                }
                StatsUtils.estimateStatsForMissingCols(neededColumns, colStats, table, conf, nr, schema);
                assert (neededColumns.size() == colStats.size());
                long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, colStats);
                ds = betterDS < 1L || colStats.isEmpty() ? ds : betterDS;
            }
            stats = new Statistics(nr, ds);
            StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), colStats);
            stats.setColumnStatsState(StatsUtils.deriveStatType(colStats, neededColumns));
            stats.addToColumnStats(colStats);
        } else if (partList != null) {
            int avgRowSize;
            long nr = 0L;
            long ds = 0L;
            ArrayList<Long> rowCounts = Lists.newArrayList();
            ArrayList<Long> dataSizes = Lists.newArrayList();
            rowCounts = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "numRows");
            dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "rawDataSize");
            nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            if (ds <= 0L) {
                dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "totalSize");
                dataSizes = StatsUtils.safeMult(dataSizes, deserFactor);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            }
            if (ds <= 0L && shouldEstimateStats) {
                dataSizes = StatsUtils.getFileSizeForPartitions(conf, partList.getNotDeniedPartns());
                dataSizes = StatsUtils.safeMult(dataSizes, deserFactor);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            }
            if ((avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema)) > 0) {
                StatsUtils.setUnknownRcDsToAverage(rowCounts, dataSizes, avgRowSize);
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (nr <= 0L) {
                    nr = ds / (long)avgRowSize;
                }
            }
            if (nr == 0L) {
                nr = 1L;
            }
            stats = new Statistics(nr, ds);
            if (StatsUtils.containsNonPositives(rowCounts) && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE)) {
                stats.setBasicStatsState(Statistics.State.PARTIAL);
            }
            if (fetchColStats) {
                void var25_31;
                boolean statsRetrieved;
                List<String> partitionColsToRetrieve;
                List<String> neededColsToRetrieve;
                List<String> partitionCols = StatsUtils.getPartitionColumns(schema, neededColumns, referencedColumns);
                ArrayList<ColStatistics> columnStats = new ArrayList<ColStatistics>();
                if (colStatsCache != null) {
                    ColStatistics colStats;
                    neededColsToRetrieve = new ArrayList<String>(neededColumns.size());
                    for (String string : neededColumns) {
                        colStats = colStatsCache.getColStats().get(string);
                        if (colStats == null) {
                            neededColsToRetrieve.add(string);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Stats for column " + string + " in table " + table.getCompleteName() + " could not be retrieved from cache");
                            continue;
                        }
                        columnStats.add(colStats);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Stats for column " + string + " in table " + table.getCompleteName() + " retrieved from cache");
                    }
                    partitionColsToRetrieve = new ArrayList<String>(partitionCols.size());
                    for (String string : partitionCols) {
                        colStats = colStatsCache.getColStats().get(string);
                        if (colStats == null) {
                            partitionColsToRetrieve.add(string);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Stats for column " + string + " in table " + table.getCompleteName() + " could not be retrieved from cache");
                            continue;
                        }
                        columnStats.add(colStats);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Stats for column " + string + " in table " + table.getCompleteName() + " retrieved from cache");
                    }
                } else {
                    neededColsToRetrieve = neededColumns;
                    partitionColsToRetrieve = partitionCols;
                }
                ArrayList<String> partNames = new ArrayList<String>(partList.getNotDeniedPartns().size());
                for (Partition part : partList.getNotDeniedPartns()) {
                    partNames.add(part.getName());
                }
                Object var25_29 = null;
                if (neededColsToRetrieve.size() > 0 && partNames.size() > 0) {
                    AggrStats aggrStats = Hive.get().getAggrColStatsFor(table.getDbName(), table.getTableName(), neededColsToRetrieve, partNames);
                }
                boolean bl = statsRetrieved = var25_31 != null && var25_31.getColStats() != null && var25_31.getColStatsSize() != 0;
                if (neededColumns.size() == 0 || neededColsToRetrieve.size() > 0 && !statsRetrieved) {
                    StatsUtils.estimateStatsForMissingCols(neededColsToRetrieve, columnStats, table, conf, nr, schema);
                    StatsUtils.addPartitionColumnStats(conf, partitionColsToRetrieve, schema, table, partList, columnStats);
                    stats.addToDataSize(StatsUtils.getDataSizeFromColumnStats(nr, columnStats));
                    stats.updateColumnStatsState(StatsUtils.deriveStatType(columnStats, referencedColumns));
                    stats.addToColumnStats(columnStats);
                } else {
                    if (statsRetrieved) {
                        columnStats.addAll(StatsUtils.convertColStats(var25_31.getColStats(), table.getTableName()));
                    }
                    int colStatsAvailable = neededColumns.size() + partitionCols.size() - partitionColsToRetrieve.size();
                    if (columnStats.size() != colStatsAvailable) {
                        LOG.debug("Column stats requested for : {} columns. Able to retrieve for {} columns", (Object)columnStats.size(), (Object)colStatsAvailable);
                    }
                    StatsUtils.addPartitionColumnStats(conf, partitionColsToRetrieve, schema, table, partList, columnStats);
                    long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, columnStats);
                    stats.setDataSize(betterDS < 1L || columnStats.isEmpty() ? ds : betterDS);
                    StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), columnStats);
                    stats.addToColumnStats(columnStats);
                    stats.setColumnStatsState(StatsUtils.deriveStatType(columnStats, referencedColumns));
                    if (neededColumns.size() != neededColsToRetrieve.size() || partitionCols.size() != partitionColsToRetrieve.size()) {
                        stats.updateColumnStatsState(colStatsCache.getState());
                    }
                    if (var25_31 != null && var25_31.getPartsFound() != (long)partNames.size() && stats.getColumnStatsState() != Statistics.State.NONE) {
                        stats.updateColumnStatsState(Statistics.State.PARTIAL);
                        LOG.debug("Column stats requested for : {} partitions. Able to retrieve for {} partitions", (Object)partNames.size(), (Object)var25_31.getPartsFound());
                    }
                }
                if (rowCounts.size() == 0) {
                    stats.setBasicStatsState(Statistics.State.COMPLETE);
                }
                if (colStatsCache != null && failIfCacheMiss && stats.getColumnStatsState().equals((Object)Statistics.State.COMPLETE) && (!neededColsToRetrieve.isEmpty() || !partitionColsToRetrieve.isEmpty())) {
                    throw new HiveException("Cache has been loaded in logical planning phase for all columns; however, stats for column some columns could not be retrieved from it (see messages above)");
                }
            }
        }
        return stats;
    }

    public static void inferAndSetPrimaryKey(long numRows, List<ColStatistics> colStats) {
        if (colStats != null) {
            for (ColStatistics cs : colStats) {
                if (cs != null && cs.getCountDistint() >= numRows) {
                    cs.setPrimaryKey(true);
                    continue;
                }
                if (cs == null || cs.getRange() == null || cs.getRange().minValue == null || cs.getRange().maxValue == null || numRows != cs.getRange().maxValue.longValue() - cs.getRange().minValue.longValue() + 1L) continue;
                cs.setPrimaryKey(true);
            }
        }
    }

    public static boolean inferForeignKey(ColStatistics csPK, ColStatistics csFK) {
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            ColStatistics.Range pkRange = csPK.getRange();
            ColStatistics.Range fkRange = csFK.getRange();
            return StatsUtils.isWithin(fkRange, pkRange);
        }
        return false;
    }

    public static float getScaledSelectivity(ColStatistics csPK, ColStatistics csFK) {
        float scaledSelectivity = 1.0f;
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            long pkRangeDelta = StatsUtils.getRangeDelta(csPK.getRange());
            long fkRangeDelta = StatsUtils.getRangeDelta(csFK.getRange());
            if (fkRangeDelta > 0L && pkRangeDelta > 0L && fkRangeDelta < pkRangeDelta) {
                scaledSelectivity = (float)pkRangeDelta / (float)fkRangeDelta;
            }
        }
        return scaledSelectivity;
    }

    public static long getRangeDelta(ColStatistics.Range range) {
        if (range.minValue != null && range.maxValue != null) {
            return range.maxValue.longValue() - range.minValue.longValue();
        }
        return 0L;
    }

    private static boolean isWithin(ColStatistics.Range range1, ColStatistics.Range range2) {
        return range1.minValue != null && range2.minValue != null && range1.maxValue != null && range2.maxValue != null && range1.minValue.longValue() >= range2.minValue.longValue() && range1.maxValue.longValue() <= range2.maxValue.longValue();
    }

    private static void addPartitionColumnStats(HiveConf conf, List<String> partitionCols, List<ColumnInfo> schema, Table table, PrunedPartitionList partList, List<ColStatistics> colStats) throws HiveException {
        for (String col : partitionCols) {
            for (ColumnInfo ci : schema) {
                if (!col.equals(ci.getInternalName())) continue;
                colStats.add(StatsUtils.getColStatsForPartCol(ci, new PartitionIterable(partList.getPartitions()), conf));
            }
        }
    }

    private static List<String> getPartitionColumns(List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns) {
        ArrayList<String> partitionCols = new ArrayList<String>(referencedColumns.size());
        ArrayList<String> extraCols = Lists.newArrayList(referencedColumns);
        if (referencedColumns.size() > neededColumns.size()) {
            extraCols.removeAll(neededColumns);
            for (String col : extraCols) {
                for (ColumnInfo ci : schema) {
                    if (!col.equals(ci.getInternalName()) || !ci.getIsVirtualCol() || ci.isHiddenVirtualCol()) continue;
                    partitionCols.add(col);
                }
            }
        }
        return partitionCols;
    }

    public static ColStatistics getColStatsForPartCol(ColumnInfo ci, PartitionIterable partList, HiveConf conf) {
        ColStatistics partCS = new ColStatistics(ci.getInternalName(), ci.getType().getTypeName());
        long numPartitions = StatsUtils.getNDVPartitionColumn(partList, ci.getInternalName());
        partCS.setCountDistint(numPartitions);
        partCS.setAvgColLen(StatsUtils.getAvgColLenOf(conf, ci.getObjectInspector(), partCS.getColumnType()));
        partCS.setRange(StatsUtils.getRangePartitionColumn(partList, ci.getInternalName(), ci.getType().getTypeName(), conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME)));
        return partCS;
    }

    public static int getNDVPartitionColumn(PartitionIterable partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>();
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    private static ColStatistics.Range getRangePartitionColumn(PartitionIterable partitions, String partColName, String colType, String defaultPartName) {
        ColStatistics.Range range = null;
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint")) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                long value = Long.parseLong(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else if (colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                double value = Double.parseDouble(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else if (colTypeLowerCase.startsWith("decimal")) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                double value = new BigDecimal(partVal).doubleValue();
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else {
            return null;
        }
        return range;
    }

    private static void setUnknownRcDsToAverage(List<Long> rowCounts, List<Long> dataSizes, int avgRowSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Estimated average row size: " + avgRowSize);
        }
        for (int i = 0; i < rowCounts.size(); ++i) {
            long rc = rowCounts.get(i);
            long s = dataSizes.get(i);
            if (rc <= 0L && s > 0L) {
                rc = s / (long)avgRowSize;
                rowCounts.set(i, rc);
            }
            if (s > 0L || rc <= 0L) continue;
            s = StatsUtils.safeMult(rc, avgRowSize);
            dataSizes.set(i, s);
        }
    }

    public static int estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema) {
        ArrayList<String> neededColumns = new ArrayList<String>();
        for (ColumnInfo ci : schema) {
            neededColumns.add(ci.getInternalName());
        }
        return StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns);
    }

    public static int estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns) {
        int avgRowSize = 0;
        for (String neededCol : neededColumns) {
            ColumnInfo ci = StatsUtils.getColumnInfoForColumn(neededCol, schema);
            if (ci == null) continue;
            ObjectInspector oi = ci.getObjectInspector();
            String colTypeLowerCase = ci.getTypeName().toLowerCase();
            if (colTypeLowerCase.equals("string") || colTypeLowerCase.equals("binary") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("array") || colTypeLowerCase.startsWith("map") || colTypeLowerCase.startsWith("struct") || colTypeLowerCase.startsWith("uniontype")) {
                avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase));
                continue;
            }
            avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase));
        }
        return avgRowSize;
    }

    private static ColumnInfo getColumnInfoForColumn(String neededCol, List<ColumnInfo> schema) {
        for (ColumnInfo ci : schema) {
            if (!ci.getInternalName().equalsIgnoreCase(neededCol)) continue;
            return ci;
        }
        return null;
    }

    public static long getFileSizeForTable(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = fs.getContentSummary(path).getLength();
        }
        catch (Exception e) {
            size = 0L;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getFileSizeForPartitions(final HiveConf conf, List<Partition> parts) {
        LOG.info("Number of partitions : " + parts.size());
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        int threads = Math.max(1, conf.getIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT));
        ExecutorService pool = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Partitions-Size-%d").build());
        ArrayList<Long> sizes = new ArrayList<Long>(parts.size());
        for (Partition part : parts) {
            final Path path = part.getDataLocation();
            futures.add(pool.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    try {
                        LOG.debug("Partition path : " + path);
                        FileSystem fs = path.getFileSystem((Configuration)conf);
                        return fs.getContentSummary(path).getLength();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }
            }));
        }
        try {
            for (int i = 0; i < futures.size(); ++i) {
                sizes.add(i, (Long)((Future)futures.get(i)).get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Exception in processing files ", e);
        }
        finally {
            pool.shutdownNow();
        }
        return sizes;
    }

    private static boolean containsNonPositives(List<Long> vals) {
        for (Long val : vals) {
            if (val > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getSumIgnoreNegatives(List<Long> vals) {
        long result = 0L;
        for (Long l : vals) {
            if (l <= 0L) continue;
            result = StatsUtils.safeAdd(result, l);
        }
        return result;
    }

    private static Statistics.State deriveStatType(List<ColStatistics> colStats, List<String> neededColumns) {
        boolean hasNull;
        boolean hasStats = false;
        boolean bl = hasNull = colStats == null || colStats.size() < neededColumns.size();
        if (colStats != null) {
            ColStatistics cs;
            boolean isNull;
            Iterator<ColStatistics> iterator = colStats.iterator();
            while (!(!iterator.hasNext() || (hasNull |= (isNull = (cs = iterator.next()) == null ? true : cs.isEstimated())) && (hasStats |= !isNull))) {
            }
        }
        Statistics.State result = hasStats ? (hasNull ? Statistics.State.PARTIAL : Statistics.State.COMPLETE) : (neededColumns.isEmpty() ? Statistics.State.COMPLETE : Statistics.State.NONE);
        return result;
    }

    public static ColStatistics getColStatistics(ColumnStatisticsObj cso, String tabName, String colName) {
        String colTypeLowerCase = cso.getColType().toLowerCase();
        ColStatistics cs = new ColStatistics(colName, colTypeLowerCase);
        ColumnStatisticsData csd = cso.getStatsData();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("float")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("double")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setCountDistint(csd.getStringStats().getNumDVs());
            cs.setNumNulls(csd.getStringStats().getNumNulls());
            cs.setAvgColLen(csd.getStringStats().getAvgColLen());
        } else if (colTypeLowerCase.equals("boolean")) {
            if (csd.getBooleanStats().getNumFalses() > 0L && csd.getBooleanStats().getNumTrues() > 0L) {
                cs.setCountDistint(2L);
            } else {
                cs.setCountDistint(1L);
            }
            cs.setNumTrues(csd.getBooleanStats().getNumTrues());
            cs.setNumFalses(csd.getBooleanStats().getNumFalses());
            cs.setNumNulls(csd.getBooleanStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("binary")) {
            cs.setAvgColLen(csd.getBinaryStats().getAvgColLen());
            cs.setNumNulls(csd.getBinaryStats().getNumNulls());
        } else if (colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("timestamp with local time zone")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setCountDistint(csd.getDecimalStats().getNumDVs());
            cs.setNumNulls(csd.getDecimalStats().getNumNulls());
            Decimal highValue = csd.getDecimalStats().getHighValue();
            Decimal lowValue = csd.getDecimalStats().getLowValue();
            if (highValue != null && highValue.getUnscaled() != null && lowValue != null && lowValue.getUnscaled() != null) {
                BigDecimal minVal;
                HiveDecimal maxHiveDec = HiveDecimal.create(new BigInteger(highValue.getUnscaled()), (int)highValue.getScale());
                BigDecimal maxVal = maxHiveDec == null ? null : maxHiveDec.bigDecimalValue();
                HiveDecimal minHiveDec = HiveDecimal.create(new BigInteger(lowValue.getUnscaled()), (int)lowValue.getScale());
                BigDecimal bigDecimal = minVal = minHiveDec == null ? null : minHiveDec.bigDecimalValue();
                if (minVal != null && maxVal != null) {
                    cs.setRange(minVal, maxVal);
                }
            }
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
            cs.setNumNulls(csd.getDateStats().getNumNulls());
            Long lowVal = csd.getDateStats().getLowValue() != null ? Long.valueOf(csd.getDateStats().getLowValue().getDaysSinceEpoch()) : null;
            Long highVal = csd.getDateStats().getHighValue() != null ? Long.valueOf(csd.getDateStats().getHighValue().getDaysSinceEpoch()) : null;
            cs.setRange(lowVal, highVal);
        } else {
            return null;
        }
        return cs;
    }

    private static ColStatistics estimateColStats(long numRows, String colName, HiveConf conf, List<ColumnInfo> schema) {
        ColumnInfo cinfo = StatsUtils.getColumnInfoForColumn(colName, schema);
        ColStatistics cs = new ColStatistics(colName, cinfo.getTypeName());
        cs.setIsEstimated(true);
        String colTypeLowerCase = cinfo.getTypeName().toLowerCase();
        float ndvPercent = Math.min(100.0f, HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_NDV_ESTIMATE_PERC));
        float nullPercent = Math.min(100.0f, HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_NUM_NULLS_ESTIMATE_PERC));
        cs.setCountDistint(Math.max(1L, (long)((double)((float)numRows * ndvPercent) / 100.0)));
        cs.setNumNulls(Math.min(numRows, (long)((double)((float)numRows * nullPercent) / 100.0)));
        if (colTypeLowerCase.equals("tinyint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(-128, 127);
        } else if (colTypeLowerCase.equals("smallint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Short.MIN_VALUE, Short.MAX_VALUE);
        } else if (colTypeLowerCase.equals("int")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Long.MIN_VALUE, Long.MAX_VALUE);
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else if (colTypeLowerCase.equals("float")) {
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        } else if (colTypeLowerCase.equals("double")) {
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(Double.MIN_VALUE, Double.MAX_VALUE);
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("binary") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setAvgColLen(StatsUtils.getAvgColLenOf(conf, cinfo.getObjectInspector(), cinfo.getTypeName()));
        } else if (colTypeLowerCase.equals("boolean")) {
            cs.setCountDistint(2L);
            cs.setNumTrues(Math.max(1L, numRows / 2L));
            cs.setNumFalses(Math.max(1L, numRows / 2L));
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("timestamp with local time zone")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setRange(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
            cs.setRange(0, 25201);
        } else {
            cs.setAvgColLen(StatsUtils.getSizeOfComplexTypes(conf, cinfo.getObjectInspector()));
        }
        return cs;
    }

    private static List<ColStatistics> estimateStats(Table table, List<ColumnInfo> schema, List<String> neededColumns, HiveConf conf, long nr) {
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(neededColumns.size());
        for (int i = 0; i < neededColumns.size(); ++i) {
            ColStatistics cs = StatsUtils.estimateColStats(nr, neededColumns.get(i), conf, schema);
            stats.add(cs);
        }
        return stats;
    }

    public static List<ColStatistics> getTableColumnStats(Table table, List<ColumnInfo> schema, List<String> neededColumns, ColumnStatsList colStatsCache) {
        List<String> colStatsToRetrieve;
        if (table.isMaterializedTable()) {
            LOG.debug("Materialized table does not contain table statistics");
            return null;
        }
        if (colStatsCache != null) {
            colStatsToRetrieve = new ArrayList<String>(neededColumns.size());
            for (String colName : neededColumns) {
                if (colStatsCache.getColStats().containsKey(colName)) continue;
                colStatsToRetrieve.add(colName);
            }
        } else {
            colStatsToRetrieve = neededColumns;
        }
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        if ("_dummy_database".equals(dbName) && "_dummy_table".equals(tabName)) {
            return null;
        }
        List<ColStatistics> stats = null;
        try {
            List<ColumnStatisticsObj> colStat = Hive.get().getTableColumnStatistics(dbName, tabName, colStatsToRetrieve);
            stats = StatsUtils.convertColStats(colStat, tabName);
        }
        catch (HiveException e) {
            LOG.error("Failed to retrieve table statistics: ", e);
            stats = new ArrayList<ColStatistics>();
        }
        if (colStatsCache != null) {
            for (String col : neededColumns) {
                ColStatistics cs = colStatsCache.getColStats().get(col);
                if (cs == null) continue;
                stats.add(cs);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Stats for column " + cs.getColumnName() + " in table " + table.getCompleteName() + " retrieved from cache");
            }
        }
        return stats;
    }

    private static List<ColStatistics> convertColStats(List<ColumnStatisticsObj> colStats, String tabName) {
        if (colStats == null) {
            return new ArrayList<ColStatistics>();
        }
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(colStats.size());
        for (ColumnStatisticsObj statObj : colStats) {
            ColStatistics cs = StatsUtils.getColStatistics(statObj, tabName, statObj.getColName());
            if (cs == null) continue;
            stats.add(cs);
        }
        return stats;
    }

    public static long getAvgColLenOf(HiveConf conf, ObjectInspector oi, String colType) {
        long configVarLen = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
        String colTypeLowCase = colType.toLowerCase();
        if (colTypeLowCase.equals("string")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof StringObjectInspector) {
                return configVarLen;
            }
        } else if (colTypeLowCase.startsWith("varchar")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveVarcharObjectInspector) {
                VarcharTypeInfo type = (VarcharTypeInfo)((HiveVarcharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.startsWith("char")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveCharObjectInspector) {
                CharTypeInfo type = (CharTypeInfo)((HiveCharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.equals("binary")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                BytesWritable constantValue = (BytesWritable)coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.getLength();
            }
            if (oi instanceof BinaryObjectInspector) {
                return configVarLen;
            }
        } else {
            return StatsUtils.getSizeOfComplexTypes(conf, oi);
        }
        throw new IllegalArgumentException("Size requested for unknown type: " + colType + " OI: " + oi.getTypeName());
    }

    public static long getSizeOfComplexTypes(HiveConf conf, ObjectInspector oi) {
        long result = 0L;
        int length = 0;
        int listEntries = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_LIST_NUM_ENTRIES);
        int mapEntries = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_MAP_NUM_ENTRIES);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String colTypeLowerCase = oi.getTypeName().toLowerCase();
                if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForStringOfLength(avgColLen);
                    break;
                }
                if (colTypeLowerCase.equals("binary")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += JavaDataModel.get().lengthForByteArrayOfSize(avgColLen);
                    break;
                }
                result += StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase);
                break;
            }
            case LIST: {
                if (oi instanceof StandardConstantListObjectInspector) {
                    StandardConstantListObjectInspector scloi = (StandardConstantListObjectInspector)oi;
                    length = scloi.getWritableConstantValue().size();
                    ObjectInspector leoi = scloi.getListElementObjectInspector();
                    if (leoi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
                        result += StatsUtils.getSizeOfPrimitiveTypeArraysFromType(leoi.getTypeName(), length, conf);
                        break;
                    }
                    result += JavaDataModel.get().lengthForObjectArrayOfSize(length);
                    break;
                }
                StandardListObjectInspector sloi = (StandardListObjectInspector)oi;
                long elemSize = StatsUtils.getSizeOfComplexTypes(conf, sloi.getListElementObjectInspector());
                result += (long)JavaDataModel.get().arrayList() + (long)listEntries * elemSize;
                break;
            }
            case MAP: {
                if (oi instanceof StandardConstantMapObjectInspector) {
                    StandardConstantMapObjectInspector scmoi = (StandardConstantMapObjectInspector)oi;
                    result += StatsUtils.getSizeOfMap(scmoi);
                    break;
                }
                StandardMapObjectInspector smoi = (StandardMapObjectInspector)oi;
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapKeyObjectInspector());
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapValueObjectInspector());
                result += (long)JavaDataModel.get().hashMap(mapEntries);
                break;
            }
            case STRUCT: {
                if (oi instanceof StandardConstantStructObjectInspector) {
                    StandardConstantStructObjectInspector scsoi = (StandardConstantStructObjectInspector)oi;
                    result += StatsUtils.getSizeOfStruct(scsoi);
                    break;
                }
                StructObjectInspector soi = (StructObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, structField.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(uoi.getObjectInspectors().size() * JavaDataModel.get().primitive1());
                for (ObjectInspector objectInspector : uoi.getObjectInspectors()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, objectInspector);
                }
                break;
            }
        }
        return result;
    }

    public static long getAvgColLenOfFixedLengthTypes(String colType) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("void") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().primitive1();
        }
        if (colTypeLowerCase.equals("double") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("interval_year_month") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().primitive2();
        }
        if (colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("timestamp with local time zone")) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (colTypeLowerCase.equals("interval_day_time")) {
            return 12L;
        }
        return 0L;
    }

    public static long getSizeOfPrimitiveTypeArraysFromType(String colType, int length, HiveConf conf) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().lengthForIntArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("double")) {
            return JavaDataModel.get().lengthForDoubleArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().lengthForLongArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("binary")) {
            return JavaDataModel.get().lengthForByteArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("boolean")) {
            return JavaDataModel.get().lengthForBooleanArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("datetime") || colTypeLowerCase.equals("interval_year_month") || colTypeLowerCase.equals("interval_day_time") || colTypeLowerCase.equals("timestamp with local time zone")) {
            return JavaDataModel.get().lengthForTimestampArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthForDateArrayOfSize(length);
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthForDecimalArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
            int configVarLen = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
            int siz = JavaDataModel.get().lengthForStringOfLength(configVarLen);
            return JavaDataModel.get().lengthForPrimitiveArrayOfSize(siz, length);
        }
        return 0L;
    }

    public static long getSizeOfMap(StandardConstantMapObjectInspector scmoi) {
        Object map = scmoi.getWritableConstantValue();
        ObjectInspector koi = scmoi.getMapKeyObjectInspector();
        ObjectInspector voi = scmoi.getMapValueObjectInspector();
        long result = 0L;
        for (Map.Entry entry : map.entrySet()) {
            result += StatsUtils.getWritableSize(koi, entry.getKey());
            result += StatsUtils.getWritableSize(voi, entry.getValue());
        }
        return result += (long)JavaDataModel.get().hashMap(map.entrySet().size());
    }

    public static long getSizeOfStruct(StandardConstantStructObjectInspector soi) {
        long result = 0L;
        result += (long)JavaDataModel.get().object();
        result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
        Object value = soi.getWritableConstantValue();
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        if (value == null || value.size() != fields.size()) {
            return result;
        }
        for (int i = 0; i < fields.size(); ++i) {
            result += StatsUtils.getWritableSize(fields.get(i).getFieldObjectInspector(), value.get(i));
        }
        return result;
    }

    public static long getWritableSize(ObjectInspector oi, Object value) {
        if (oi instanceof WritableStringObjectInspector) {
            WritableStringObjectInspector woi = (WritableStringObjectInspector)oi;
            return JavaDataModel.get().lengthForStringOfLength(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBinaryObjectInspector) {
            WritableBinaryObjectInspector woi = (WritableBinaryObjectInspector)oi;
            return JavaDataModel.get().lengthForByteArrayOfSize(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBooleanObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableByteObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableDateObjectInspector) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (oi instanceof WritableDoubleObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableFloatObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableHiveDecimalObjectInspector) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (oi instanceof WritableIntObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableLongObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableShortObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableTimestampObjectInspector || oi instanceof WritableTimestampLocalTZObjectInspector) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        return 0L;
    }

    public static List<ColStatistics> getColStatisticsFromExprMap(HiveConf conf, Statistics parentStats, Map<String, ExprNodeDesc> colExprMap, RowSchema rowSchema) {
        ArrayList<ColStatistics> cs = Lists.newArrayList();
        if (colExprMap != null && rowSchema != null) {
            for (ColumnInfo columnInfo : rowSchema.getSignature()) {
                String outColName = columnInfo.getInternalName();
                ExprNodeDesc end = colExprMap.get(outColName);
                ColStatistics colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end);
                if (colStat == null) continue;
                colStat.setColumnName(outColName);
                cs.add(colStat);
            }
            for (Map.Entry entry : colExprMap.entrySet()) {
                ColStatistics colStat;
                if (rowSchema.getColumnInfo((String)entry.getKey()) != null || (colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, (ExprNodeDesc)entry.getValue())) == null) continue;
                colStat.setColumnName((String)entry.getKey());
                cs.add(colStat);
            }
            return cs;
        }
        if ((colExprMap == null || rowSchema == null) && parentStats.getColumnStats() != null) {
            cs.addAll(parentStats.getColumnStats());
        }
        return cs;
    }

    public static List<ColStatistics> getColStatisticsUpdatingTableAlias(Statistics parentStats, RowSchema rowSchema) {
        ArrayList<ColStatistics> cs = Lists.newArrayList();
        for (ColStatistics parentColStat : parentStats.getColumnStats()) {
            ColStatistics colStat = parentColStat.clone();
            if (colStat == null) continue;
            cs.add(colStat);
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ColStatistics getColStatisticsFromExpression(HiveConf conf, Statistics parentStats, ExprNodeDesc end) {
        ObjectInspector oi;
        long numNulls;
        long countDistincts;
        double avgColSize;
        String colType;
        String colName;
        block16: {
            ExprNodeDesc encd;
            if (end == null) {
                return null;
            }
            colName = null;
            colType = null;
            avgColSize = 0.0;
            countDistincts = 0L;
            numNulls = 0L;
            oi = end.getWritableObjectInspector();
            long numRows = parentStats.getNumRows();
            if (end instanceof ExprNodeColumnDesc) {
                encd = (ExprNodeColumnDesc)end;
                colName = ((ExprNodeColumnDesc)encd).getColumn();
                if (((ExprNodeColumnDesc)encd).getIsPartitionColOrVirtualCol()) {
                    ColStatistics colStats = parentStats.getColumnStatisticsFromColName(colName);
                    if (colStats != null) {
                        return colStats.clone();
                    }
                    colType = encd.getTypeInfo().getTypeName();
                    countDistincts = numRows;
                    break block16;
                } else {
                    ColStatistics result = parentStats.getColumnStatisticsFromColName(colName);
                    if (result != null) {
                        return result.clone();
                    }
                    return null;
                }
            }
            if (end instanceof ExprNodeConstantDesc) {
                encd = (ExprNodeConstantDesc)end;
                colName = encd.getName();
                colType = encd.getTypeString();
                if (((ExprNodeConstantDesc)encd).getValue() == null) {
                    numNulls = numRows;
                } else {
                    countDistincts = 1L;
                }
            } else if (end instanceof ExprNodeGenericFuncDesc) {
                ColStatistics stats;
                ExprNodeGenericFuncDesc engfd = (ExprNodeGenericFuncDesc)end;
                colName = engfd.getName();
                colType = engfd.getTypeString();
                if (StatsUtils.isWideningCast(engfd) && engfd.getChildren().get(0) instanceof ExprNodeColumnDesc && (stats = parentStats.getColumnStatisticsFromColName(engfd.getCols().get(0))) != null) {
                    ColStatistics newStats = stats.clone();
                    newStats.setColumnName(colName);
                    colType = colType.toLowerCase();
                    newStats.setColumnType(colType);
                    newStats.setAvgColLen(StatsUtils.getAvgColLenOf(conf, oi, colType));
                    return newStats;
                }
                countDistincts = StatsUtils.getNDVFor(engfd, numRows, parentStats);
            } else if (end instanceof ExprNodeColumnListDesc) {
                encd = (ExprNodeColumnListDesc)end;
                colName = Joiner.on(",").join(((ExprNodeColumnListDesc)encd).getCols());
                colType = "array";
                countDistincts = numRows;
            } else {
                if (!(end instanceof ExprNodeFieldDesc)) {
                    throw new IllegalArgumentException("not supported expr type " + end.getClass());
                }
                ExprNodeFieldDesc enfd = (ExprNodeFieldDesc)end;
                colName = enfd.getFieldName();
                colType = enfd.getTypeString();
                countDistincts = numRows;
            }
        }
        colType = colType.toLowerCase();
        avgColSize = StatsUtils.getAvgColLenOf(conf, oi, colType);
        ColStatistics colStats = new ColStatistics(colName, colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        return colStats;
    }

    private static boolean isWideningCast(ExprNodeGenericFuncDesc engfd) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isOpCast(udf)) {
            return false;
        }
        return TypeInfoUtils.implicitConvertible(engfd.getChildren().get(0).getTypeInfo(), engfd.getTypeInfo());
    }

    public static Long addWithExpDecay(List<Long> distinctVals) {
        Collections.sort(distinctVals, Collections.reverseOrder());
        long denom = distinctVals.get(0);
        for (int i = 1; i < distinctVals.size(); ++i) {
            denom = (long)((double)denom * Math.pow(distinctVals.get(i).longValue(), 1.0 / (double)(1 << i)));
        }
        return denom;
    }

    private static long getNDVFor(ExprNodeGenericFuncDesc engfd, long numRows, Statistics parentStats) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isDeterministic(udf) && !FunctionRegistry.isRuntimeConstant(udf)) {
            return numRows;
        }
        ArrayList<Long> ndvs = Lists.newArrayList();
        Class<Object> udfClass = udf instanceof GenericUDFBridge ? ((GenericUDFBridge)udf).getUdfClass() : udf.getClass();
        NDV ndv = AnnotationUtils.getAnnotation(udfClass, NDV.class);
        long udfNDV = Long.MAX_VALUE;
        if (ndv != null) {
            udfNDV = ndv.maxNdv();
        } else {
            for (String col : engfd.getCols()) {
                ColStatistics stats = parentStats.getColumnStatisticsFromColName(col);
                if (stats == null) continue;
                ndvs.add(stats.getCountDistint());
            }
        }
        long countDistincts = ndvs.isEmpty() ? numRows : StatsUtils.addWithExpDecay(ndvs);
        return Collections.min(Lists.newArrayList(countDistincts, udfNDV, numRows));
    }

    public static long getNumRows(Table table) {
        return StatsUtils.getBasicStatForTable(table, "numRows");
    }

    public static long getRawDataSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "rawDataSize");
    }

    public static long getTotalSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "totalSize");
    }

    public static long getBasicStatForTable(Table table, String statType) {
        Map<String, String> params = table.getParameters();
        long result = -1L;
        if (params != null) {
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = -1L;
            }
        }
        return result;
    }

    public static List<Long> getBasicStatForPartitions(Table table, List<Partition> parts, String statType) {
        ArrayList<Long> stats = Lists.newArrayList();
        for (Partition part : parts) {
            Map<String, String> params = part.getParameters();
            long result = 0L;
            if (params == null) continue;
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
            stats.add(result);
        }
        return stats;
    }

    public static long getDataSizeFromColumnStats(long numRows, List<ColStatistics> colStats) {
        long result = 0L;
        if (numRows <= 0L || colStats == null) {
            return result;
        }
        if (colStats.isEmpty()) {
            return numRows * 8L;
        }
        for (ColStatistics cs : colStats) {
            int acl;
            if (cs == null) continue;
            String colTypeLowerCase = cs.getColumnType().toLowerCase();
            long nonNullCount = cs.getNumNulls() > 0L ? numRows - cs.getNumNulls() + 1L : numRows;
            double sizeOf = 0.0;
            if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
                sizeOf = cs.getAvgColLen();
            } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForStringOfLength(acl);
            } else if (colTypeLowerCase.equals("binary")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForByteArrayOfSize(acl);
            } else {
                sizeOf = colTypeLowerCase.equals("timestamp") || colTypeLowerCase.equals("timestamp with local time zone") ? (double)JavaDataModel.get().lengthOfTimestamp() : (colTypeLowerCase.startsWith("decimal") ? (double)JavaDataModel.get().lengthOfDecimal() : (colTypeLowerCase.equals("date") ? (double)JavaDataModel.get().lengthOfDate() : cs.getAvgColLen()));
            }
            result = StatsUtils.safeAdd(result, StatsUtils.safeMult(nonNullCount, sizeOf));
        }
        return result;
    }

    public static String getFullyQualifiedTableName(String dbName, String tabName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName);
    }

    private static String getFullyQualifiedName(String ... names) {
        ArrayList<String> nonNullAndEmptyNames = Lists.newArrayList();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            nonNullAndEmptyNames.add(name);
        }
        return Joiner.on(".").join(nonNullAndEmptyNames);
    }

    public static List<String> getQualifedReducerKeyNames(List<String> keyExprs) {
        ArrayList<String> result = Lists.newArrayList();
        if (keyExprs != null) {
            for (String key : keyExprs) {
                result.add(Utilities.ReduceField.KEY.toString() + "." + key);
            }
        }
        return result;
    }

    public static long getAvailableMemory(Configuration conf) {
        int memory = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVETEZCONTAINERSIZE);
        if (memory <= 0 && (memory = conf.getInt("mapreduce.map.memory.mb", 1024)) <= 0) {
            memory = 1024;
        }
        return memory;
    }

    public static long getMaxIfOverflow(long val) {
        return val < 0L ? Long.MAX_VALUE : val;
    }

    public static long safeMult(long a, double b) {
        double result = (double)a * b;
        return result > 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    public static long safeAdd(long a, long b) {
        try {
            return LongMath.checkedAdd(a, b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static long safeMult(long a, long b) {
        try {
            return LongMath.checkedMultiply(a, b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static List<Long> safeMult(List<Long> l, float b) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (Long a : l) {
            ret.add(StatsUtils.safeMult((long)a, (double)b));
        }
        return ret;
    }

    public static boolean hasDiscreteRange(ColStatistics colStat) {
        TypeInfo colType;
        if (colStat.getRange() != null && (colType = TypeInfoUtils.getTypeInfoFromTypeString(colStat.getColumnType())).getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveTypeInfo pti = (PrimitiveTypeInfo)colType;
            switch (pti.getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
        }
        return false;
    }

    public static ColStatistics.Range combineRange(ColStatistics.Range range1, ColStatistics.Range range2) {
        if (range1.minValue != null && range1.maxValue != null && range2.minValue != null && range2.maxValue != null) {
            long min1 = range1.minValue.longValue();
            long max1 = range1.maxValue.longValue();
            long min2 = range2.minValue.longValue();
            long max2 = range2.maxValue.longValue();
            if (max1 < min2 || max2 < min1) {
                return null;
            }
            return new ColStatistics.Range(Math.min(min1, min2), Math.max(max1, max2));
        }
        return null;
    }

    public static boolean areBasicStatsUptoDateForQueryAnswering(Table table, Map<String, String> params) {
        if (MetaStoreUtils.isExternalTable(table.getTTable())) {
            return false;
        }
        return StatsSetupConst.areBasicStatsUptoDate(params);
    }

    public static boolean areColumnStatsUptoDateForQueryAnswering(Table table, Map<String, String> params, String colName) {
        if (MetaStoreUtils.isExternalTable(table.getTTable())) {
            return false;
        }
        return StatsSetupConst.areColumnStatsUptoDate(params, colName);
    }
}

