/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.HiveStrictManagedUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;

public class HiveStrictManagedMigration {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStrictManagedMigration.class);
    private RunOptions runOptions;
    private Configuration conf;
    private HiveMetaStoreClient hms;
    private boolean failedValidationChecks;
    private Warehouse wh;
    private Warehouse oldWh;
    private String ownerName;
    private String groupName;
    private FsPermission dirPerms;
    private FsPermission filePerms;
    MyDriver driver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RunOptions runOptions;
        try {
            .Options opts = HiveStrictManagedMigration.createOptions();
            .CommandLine cli = new .GnuParser().parse(opts, args);
            if (cli.hasOption('h')) {
                .HelpFormatter formatter = new .HelpFormatter();
                formatter.printHelp(HiveStrictManagedMigration.class.getName(), opts);
                return;
            }
            runOptions = HiveStrictManagedMigration.createRunOptions(cli);
        }
        catch (Exception err) {
            throw new Exception("Error processing options", err);
        }
        int rc = 0;
        HiveStrictManagedMigration migration = null;
        try {
            migration = new HiveStrictManagedMigration(runOptions);
            migration.run();
        }
        catch (Exception err) {
            LOG.error("Failed with error", err);
            rc = -1;
        }
        finally {
            if (migration != null) {
                migration.cleanup();
            }
        }
        System.exit(rc);
    }

    static .Options createOptions() {
        .Options result = new .Options();
        .OptionBuilder.withValueSeparator();
        .OptionBuilder.hasArgs((int)2);
        .OptionBuilder.withArgName((String)"property=value");
        .OptionBuilder.withLongOpt((String)"hiveconf");
        .OptionBuilder.withDescription((String)"Use value for given property");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"dryRun");
        .OptionBuilder.withDescription((String)"Show what migration actions would be taken without actually running commands");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"dbRegex");
        .OptionBuilder.withDescription((String)"Regular expression to match database names on which this tool will be run");
        .OptionBuilder.hasArg();
        result.addOption(.OptionBuilder.create((char)'d'));
        .OptionBuilder.withLongOpt((String)"tableRegex");
        .OptionBuilder.withDescription((String)"Regular expression to match table names on which this tool will be run");
        .OptionBuilder.hasArg();
        result.addOption(.OptionBuilder.create((char)'t'));
        .OptionBuilder.withLongOpt((String)"oldWarehouseRoot");
        .OptionBuilder.withDescription((String)"Location of the previous warehouse root");
        .OptionBuilder.hasArg();
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"migrationOption");
        .OptionBuilder.withDescription((String)"Table migration option (automatic|external|managed|validate|none)");
        .OptionBuilder.hasArg();
        result.addOption(.OptionBuilder.create((char)'m'));
        .OptionBuilder.withLongOpt((String)"shouldModifyManagedTableLocation");
        .OptionBuilder.withDescription((String)"Whether managed tables should have their data moved from the old warehouse path to the current warehouse path");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"shouldModifyManagedTableOwner");
        .OptionBuilder.withDescription((String)"Whether managed tables should have their directory owners changed to the hive user");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"shouldModifyManagedTablePermissions");
        .OptionBuilder.withDescription((String)"Whether managed tables should have their directory permissions changed to conform to strict managed tables mode");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"modifyManagedTables");
        .OptionBuilder.withDescription((String)"This setting enables the shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions options");
        result.addOption(.OptionBuilder.create());
        .OptionBuilder.withLongOpt((String)"help");
        .OptionBuilder.withDescription((String)"print help message");
        result.addOption(.OptionBuilder.create((char)'h'));
        return result;
    }

    static RunOptions createRunOptions(.CommandLine cli) throws Exception {
        Properties confProps = cli.getOptionProperties("hiveconf");
        for (String propKey : confProps.stringPropertyNames()) {
            LOG.info("Setting {}={}", (Object)propKey, (Object)confProps.getProperty(propKey));
            if (propKey.equalsIgnoreCase("hive.root.logger")) {
                CommonCliOptions.splitAndSetLogger(propKey, confProps);
                continue;
            }
            System.setProperty(propKey, confProps.getProperty(propKey));
        }
        LogUtils.initHiveLog4j();
        String dbRegex = cli.getOptionValue("dbRegex", ".*");
        String tableRegex = cli.getOptionValue("tableRegex", ".*");
        TableMigrationOption migrationOption = TableMigrationOption.valueOf(cli.getOptionValue("migrationOption", "none").toUpperCase());
        boolean shouldModifyManagedTableLocation = cli.hasOption("shouldModifyManagedTableLocation");
        boolean shouldModifyManagedTableOwner = cli.hasOption("shouldModifyManagedTableOwner");
        boolean shouldModifyManagedTablePermissions = cli.hasOption("shouldModifyManagedTablePermissions");
        if (cli.hasOption("modifyManagedTables")) {
            shouldModifyManagedTableLocation = true;
            shouldModifyManagedTableOwner = true;
            shouldModifyManagedTablePermissions = true;
        }
        String oldWarehouseRoot = cli.getOptionValue("oldWarehouseRoot");
        boolean dryRun = cli.hasOption("dryRun");
        RunOptions runOpts = new RunOptions(dbRegex, tableRegex, oldWarehouseRoot, migrationOption, shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions, dryRun);
        return runOpts;
    }

    HiveStrictManagedMigration(RunOptions runOptions) {
        this.runOptions = runOptions;
        this.conf = MetastoreConf.newMetastoreConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        this.checkOldWarehouseRoot();
        this.checkOwnerPermsOptions();
        this.hms = new HiveMetaStoreClient(this.conf);
        try {
            List<String> databases = this.hms.getAllDatabases();
            LOG.info("Found {} databases", (Object)databases.size());
            for (String dbName : databases) {
                if (!dbName.matches(this.runOptions.dbRegex)) continue;
                this.processDatabase(dbName);
            }
            LOG.info("Done processing databases.");
        }
        finally {
            this.hms.close();
        }
        if (this.failedValidationChecks) {
            throw new HiveException("One or more tables failed validation checks for strict managed table mode.");
        }
    }

    void checkOldWarehouseRoot() throws IOException, MetaException {
        if (this.runOptions.shouldModifyManagedTableLocation) {
            if (this.runOptions.oldWarehouseRoot == null) {
                LOG.info("oldWarehouseRoot is not specified. Disabling shouldModifyManagedTableLocation");
                this.runOptions.shouldModifyManagedTableLocation = false;
            } else {
                String curWarehouseRoot = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE);
                if (HiveStrictManagedMigration.arePathsEqual(this.conf, this.runOptions.oldWarehouseRoot, curWarehouseRoot)) {
                    LOG.info("oldWarehouseRoot is the same as the current warehouse root {}. Disabling shouldModifyManagedTableLocation", (Object)this.runOptions.oldWarehouseRoot);
                    this.runOptions.shouldModifyManagedTableLocation = false;
                } else {
                    FileSystem curWhRootFs;
                    FileSystem oldWhRootFs = new Path(this.runOptions.oldWarehouseRoot).getFileSystem(this.conf);
                    if (!FileUtils.equalsFileSystem(oldWhRootFs, curWhRootFs = new Path(curWarehouseRoot).getFileSystem(this.conf))) {
                        LOG.info("oldWarehouseRoot {} has a different FS than the current warehouse root {}. Disabling shouldModifyManagedTableLocation", (Object)this.runOptions.oldWarehouseRoot, (Object)curWarehouseRoot);
                        this.runOptions.shouldModifyManagedTableLocation = false;
                    } else if (!HiveStrictManagedMigration.isHdfs(oldWhRootFs)) {
                        LOG.info("Warehouse is using non-HDFS FileSystem {}. Disabling shouldModifyManagedTableLocation", (Object)oldWhRootFs.getUri());
                        this.runOptions.shouldModifyManagedTableLocation = false;
                    }
                }
            }
        }
        if (this.runOptions.shouldModifyManagedTableLocation) {
            this.wh = new Warehouse(this.conf);
            Configuration oldWhConf = new Configuration(this.conf);
            HiveConf.setVar(oldWhConf, HiveConf.ConfVars.METASTOREWAREHOUSE, this.runOptions.oldWarehouseRoot);
            this.oldWh = new Warehouse(oldWhConf);
        }
    }

    void checkOwnerPermsOptions() {
        if (this.runOptions.shouldModifyManagedTableOwner) {
            this.ownerName = this.conf.get("strict.managed.tables.migration.owner", "hive");
            this.groupName = this.conf.get("strict.managed.tables.migration.group", null);
        }
        if (this.runOptions.shouldModifyManagedTablePermissions) {
            String filePermsString;
            String dirPermsString = this.conf.get("strict.managed.tables.migration.dir.permissions", "1700");
            if (dirPermsString != null) {
                this.dirPerms = new FsPermission(dirPermsString);
            }
            if ((filePermsString = this.conf.get("strict.managed.tables.migration.dir.permissions", "700")) != null) {
                this.filePerms = new FsPermission(filePermsString);
            }
        }
    }

    void processDatabase(String dbName) throws IOException, HiveException, MetaException, TException {
        LOG.info("Processing database {}", (Object)dbName);
        Database dbObj = this.hms.getDatabase(dbName);
        boolean modifyDefaultManagedLocation = this.shouldModifyDatabaseLocation(dbObj);
        if (modifyDefaultManagedLocation) {
            Path newDefaultDbLocation = this.wh.getDefaultDatabasePath(dbName);
            LOG.info("Changing location of database {} to {}", (Object)dbName, (Object)newDefaultDbLocation);
            if (!this.runOptions.dryRun) {
                FileSystem fs = newDefaultDbLocation.getFileSystem(this.conf);
                FileUtils.mkdir(fs, newDefaultDbLocation, this.conf);
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, newDefaultDbLocation, this.ownerName, this.groupName, this.dirPerms, null, this.runOptions.dryRun, false);
                String command = String.format("ALTER DATABASE %s SET LOCATION '%s'", dbName, newDefaultDbLocation);
                this.runHiveCommand(command);
            }
        }
        List<String> tableNames = this.hms.getTables(dbName, this.runOptions.tableRegex);
        for (String tableName : tableNames) {
            this.processTable(dbObj, tableName, modifyDefaultManagedLocation);
        }
    }

    void processTable(Database dbObj, String tableName, boolean modifyDefaultManagedLocation) throws HiveException, IOException, TException {
        String dbName = dbObj.getName();
        LOG.debug("Processing table {}", (Object)HiveStrictManagedMigration.getQualifiedName(dbName, tableName));
        Table tableObj = this.hms.getTable(dbName, tableName);
        TableType tableType = TableType.valueOf(tableObj.getTableType());
        TableMigrationOption migrationOption = this.runOptions.migrationOption;
        if (migrationOption == TableMigrationOption.AUTOMATIC) {
            migrationOption = this.determineMigrationTypeAutomatically(tableObj, tableType);
        }
        switch (migrationOption) {
            case EXTERNAL: {
                boolean tableMigrated = this.migrateToExternalTable(tableObj, tableType);
                if (!tableMigrated) break;
                tableType = TableType.EXTERNAL_TABLE;
                break;
            }
            case MANAGED: {
                boolean tableMigrated = this.migrateToManagedTable(tableObj, tableType);
                if (!tableMigrated) break;
                tableType = TableType.MANAGED_TABLE;
                break;
            }
            case NONE: {
                break;
            }
            case VALIDATE: {
                String reason = HiveStrictManagedUtils.validateStrictManagedTable(this.conf, tableObj);
                if (reason == null) break;
                LOG.warn(reason);
                this.failedValidationChecks = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected table migration option " + (Object)((Object)this.runOptions.migrationOption));
            }
        }
        if (tableType == TableType.MANAGED_TABLE) {
            FileSystem fs;
            Path tablePath = new Path(tableObj.getSd().getLocation());
            if (modifyDefaultManagedLocation && this.shouldModifyTableLocation(dbObj, tableObj)) {
                Path newTablePath = this.wh.getDnsPath(new Path(this.wh.getDefaultDatabasePath(dbName), MetaStoreUtils.encodeTableName(tableName.toLowerCase())));
                this.moveTableData(dbObj, tableObj, newTablePath);
                if (!this.runOptions.dryRun) {
                    tablePath = newTablePath;
                }
            }
            if ((this.runOptions.shouldModifyManagedTableOwner || this.runOptions.shouldModifyManagedTablePermissions) && HiveStrictManagedMigration.isHdfs(fs = tablePath.getFileSystem(this.conf))) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, tablePath, this.ownerName, this.groupName, this.dirPerms, this.filePerms, this.runOptions.dryRun, true);
            }
        }
    }

    boolean shouldModifyDatabaseLocation(Database dbObj) throws IOException, MetaException {
        Path oldDefaultDbLocation;
        String dbLocation;
        String dbName = dbObj.getName();
        return this.runOptions.shouldModifyManagedTableLocation && HiveStrictManagedMigration.arePathsEqual(this.conf, dbLocation = dbObj.getLocationUri(), (oldDefaultDbLocation = this.oldWh.getDefaultDatabasePath(dbName)).toString());
    }

    boolean shouldModifyTableLocation(Database dbObj, Table tableObj) throws IOException, MetaException {
        Path oldDefaultTableLocation;
        String tableLocation = tableObj.getSd().getLocation();
        return HiveStrictManagedMigration.arePathsEqual(this.conf, tableLocation, (oldDefaultTableLocation = this.oldWh.getDefaultTablePath(dbObj, tableObj.getTableName())).toString());
    }

    boolean shouldModifyPartitionLocation(Database dbObj, Table tableObj, Partition partObj, Map<String, String> partSpec) throws IOException, MetaException {
        String tableName = tableObj.getTableName();
        String partLocation = partObj.getSd().getLocation();
        Path oldDefaultPartLocation = this.oldWh.getDefaultPartitionPath(dbObj, tableObj, partSpec);
        return HiveStrictManagedMigration.arePathsEqual(this.conf, partLocation, oldDefaultPartLocation.toString());
    }

    void moveTableData(Database dbObj, Table tableObj, Path newTablePath) throws HiveException, IOException, TException {
        FileSystem fs;
        boolean movedData;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        Path oldTablePath = new Path(tableObj.getSd().getLocation());
        LOG.info("Moving location of {} from {} to {}", HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath);
        if (!this.runOptions.dryRun && !(movedData = (fs = newTablePath.getFileSystem(this.conf)).rename(oldTablePath, newTablePath))) {
            String msg = String.format("Unable to move data directory for table %s from %s to %s", HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath);
            throw new HiveException(msg);
        }
        if (!this.runOptions.dryRun) {
            String command = String.format("ALTER TABLE %s SET LOCATION '%s'", HiveStrictManagedMigration.getQualifiedName(tableObj), newTablePath);
            this.runHiveCommand(command);
        }
        if (HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            List<String> partNames = this.hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            for (String partName : partNames) {
                Map<String, String> partSpec;
                Partition partObj = this.hms.getPartition(dbName, tableName, partName);
                if (!this.shouldModifyPartitionLocation(dbObj, tableObj, partObj, partSpec = Warehouse.makeSpecFromValues(tableObj.getPartitionKeys(), partObj.getValues())) || this.runOptions.dryRun) continue;
                Path newPartPath = this.wh.getPartitionPath(newTablePath, partSpec);
                String command = String.format("ALTER TABLE PARTITION (%s) SET LOCATION '%s'", partName, newPartPath.toString());
                this.runHiveCommand(command);
            }
        }
    }

    TableMigrationOption determineMigrationTypeAutomatically(Table tableObj, TableType tableType) throws IOException, MetaException, TException {
        TableMigrationOption result = TableMigrationOption.NONE;
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    result = TableMigrationOption.MANAGED;
                    break;
                }
                String reason = this.shouldTableBeExternal(tableObj);
                if (reason != null) {
                    LOG.debug("Converting {} to external table. {}", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj), (Object)reason);
                    result = TableMigrationOption.EXTERNAL;
                    break;
                }
                result = TableMigrationOption.MANAGED;
                break;
            }
            case EXTERNAL_TABLE: {
                String msg = String.format("Table %s is already an external table, not processing.", HiveStrictManagedMigration.getQualifiedName(tableObj));
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
                break;
            }
            default: {
                String msg = String.format("Ignoring table %s because it has table type %s", new Object[]{HiveStrictManagedMigration.getQualifiedName(tableObj), tableType});
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
            }
        }
        return result;
    }

    boolean migrateToExternalTable(Table tableObj, TableType tableType) throws HiveException {
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                LOG.info("Converting {} to external table ...", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!this.runOptions.dryRun) {
                    String command = String.format("ALTER TABLE %s SET TBLPROPERTIES ('EXTERNAL'='TRUE', 'external.table.purge'='true')", HiveStrictManagedMigration.getQualifiedName(tableObj));
                    this.runHiveCommand(command);
                }
                return true;
            }
            case EXTERNAL_TABLE: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is already an external table");
                LOG.debug(msg);
                break;
            }
            default: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table type " + (Object)((Object)tableType) + " cannot be converted");
                LOG.debug(msg);
            }
        }
        return false;
    }

    boolean migrateToManagedTable(Table tableObj, TableType tableType) throws HiveException, MetaException {
        String externalFalse = "";
        switch (tableType) {
            case EXTERNAL_TABLE: {
                externalFalse = "'EXTERNAL'='FALSE', ";
            }
            case MANAGED_TABLE: {
                if (MetaStoreUtils.isNonNativeTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a non-native (StorageHandler) table");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isAvroTableWithExternalSchema(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is an Avro table with an external schema url");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isListBucketedTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a list bucketed table");
                    LOG.debug(msg);
                    return false;
                }
                if (AcidUtils.isFullAcidTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is already a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                if (TransactionalValidationListener.conformToAcid(tableObj)) {
                    LOG.info("Converting {} to full transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                    if (!this.runOptions.dryRun) {
                        String command = String.format("ALTER TABLE %s SET TBLPROPERTIES ('transactional'='true')", HiveStrictManagedMigration.getQualifiedName(tableObj));
                        this.runHiveCommand(command);
                    }
                    return true;
                }
                LOG.info("Converting {} to insert-only transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!this.runOptions.dryRun) {
                    String command = String.format("ALTER TABLE %s SET TBLPROPERTIES (%s'transactional'='true', 'transactional_properties'='insert_only')", HiveStrictManagedMigration.getQualifiedName(tableObj), externalFalse);
                    this.runHiveCommand(command);
                }
                return true;
            }
        }
        String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table type " + (Object)((Object)tableType) + " cannot be converted");
        LOG.debug(msg);
        return false;
    }

    String shouldTableBeExternal(Table tableObj) throws IOException, MetaException, TException {
        if (MetaStoreUtils.isNonNativeTable(tableObj)) {
            return "Table is a non-native (StorageHandler) table";
        }
        if (HiveStrictManagedUtils.isAvroTableWithExternalSchema(tableObj)) {
            return "Table is an Avro table with an external schema url";
        }
        if (HiveStrictManagedUtils.isListBucketedTable(tableObj)) {
            return "Table is a list bucketed table";
        }
        if (this.shouldTablePathBeExternal(tableObj, this.ownerName)) {
            return String.format("One or more table directories not owned by %s, or non-HDFS path", this.ownerName);
        }
        return null;
    }

    boolean shouldTablePathBeExternal(Table tableObj, String userName) throws IOException, MetaException, TException {
        boolean shouldBeExternal = false;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        if (!HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            Path tablePath = new Path(tableObj.getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem(this.conf);
            shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs) ? HiveStrictManagedMigration.checkDirectoryOwnership(fs, tablePath, this.ownerName, true) : true;
        } else {
            String partName;
            Partition partObj;
            Path partPath;
            FileSystem fs;
            List<String> partNames = this.hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            Iterator<String> iterator = partNames.iterator();
            while (iterator.hasNext() && !(shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs = (partPath = new Path((partObj = this.hms.getPartition(dbName, tableName, partName = iterator.next())).getSd().getLocation())).getFileSystem(this.conf)) ? HiveStrictManagedMigration.checkDirectoryOwnership(fs, partPath, this.ownerName, true) : true)) {
            }
        }
        return shouldBeExternal;
    }

    void runHiveCommand(String command) throws HiveException {
        CommandProcessorResponse cpr;
        LOG.info("Running command: {}", (Object)command);
        if (this.driver == null) {
            this.driver = new MyDriver(this.conf);
        }
        if ((cpr = this.driver.driver.run(command)).getResponseCode() != 0) {
            String msg = "Query returned non-zero code: " + cpr.getResponseCode() + ", cause: " + cpr.getErrorMessage();
            throw new HiveException(msg);
        }
    }

    void cleanup() {
        if (this.driver != null) {
            HiveStrictManagedMigration.runAndLogErrors(() -> this.driver.close());
            this.driver = null;
        }
    }

    static void runAndLogErrors(ThrowableRunnable r) {
        try {
            r.run();
        }
        catch (Exception err) {
            LOG.error("Error encountered", err);
        }
    }

    static String createExternalConversionExcuse(Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to an external table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static String createManagedConversionExcuse(Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to a managed table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static boolean isPartitionedTable(Table tableObj) {
        List<FieldSchema> partKeys = tableObj.getPartitionKeys();
        return partKeys != null || partKeys.size() > 0;
    }

    static boolean isHdfs(FileSystem fs) {
        return fs.getScheme().equals("hdfs");
    }

    static String getQualifiedName(Table tableObj) {
        return HiveStrictManagedMigration.getQualifiedName(tableObj.getDbName(), tableObj.getTableName());
    }

    static String getQualifiedName(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append('`');
        sb.append(dbName);
        sb.append("`.`");
        sb.append(tableName);
        sb.append('`');
        return sb.toString();
    }

    static boolean arePathsEqual(Configuration conf, String path1, String path2) throws IOException {
        String qualified1 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path1));
        String qualified2 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path2));
        return qualified1.equals(qualified2);
    }

    static String getQualifiedPath(Configuration conf, Path path) throws IOException {
        if (path == null) {
            return null;
        }
        FileSystem fs = path.getFileSystem(conf);
        return fs.makeQualified(path).toString();
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, Path path, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        FileStatus fStatus = fs.getFileStatus(path);
        HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, fStatus, userName, groupName, dirPerms, filePerms, dryRun, recurse);
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, FileStatus fStatus, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        Path path = fStatus.getPath();
        boolean setOwner = false;
        if (userName != null && !userName.equals(fStatus.getOwner())) {
            setOwner = true;
        } else if (groupName != null && !groupName.equals(fStatus.getGroup())) {
            setOwner = true;
        }
        boolean isDir = fStatus.isDirectory();
        boolean setPerms = false;
        FsPermission perms = filePerms;
        if (isDir) {
            perms = dirPerms;
        }
        if (perms != null && !perms.equals((Object)fStatus.getPermission())) {
            setPerms = true;
        }
        if (setOwner) {
            LOG.debug("Setting owner/group of {} to {}/{}", path, userName, groupName);
            if (!dryRun) {
                fs.setOwner(path, userName, groupName);
            }
        }
        if (setPerms) {
            LOG.debug("Setting perms of {} to {}", (Object)path, (Object)perms);
            if (!dryRun) {
                fs.setPermission(path, perms);
            }
        }
        if (isDir && recurse) {
            for (FileStatus subFile : fs.listStatus(path)) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, subFile, userName, groupName, dirPerms, filePerms, dryRun, recurse);
            }
        }
    }

    static boolean checkDirectoryOwnership(FileSystem fs, Path path, String userName, boolean recurse) throws IOException {
        FileStatus fStatus = fs.getFileStatus(path);
        return HiveStrictManagedMigration.checkDirectoryOwnership(fs, fStatus, userName, recurse);
    }

    static boolean checkDirectoryOwnership(FileSystem fs, FileStatus fStatus, String userName, boolean recurse) throws IOException {
        Path path = fStatus.getPath();
        boolean result = true;
        boolean isDir = fStatus.isDirectory();
        if (isDir) {
            if (userName != null && !userName.equals(fStatus.getOwner())) {
                return false;
            }
            if (recurse) {
                for (FileStatus subFile : fs.listStatus(path)) {
                    if (HiveStrictManagedMigration.checkDirectoryOwnership(fs, subFile, userName, recurse)) continue;
                    return false;
                }
            }
        }
        return result;
    }

    static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    static class MyDriver {
        IDriver driver;

        MyDriver(Configuration conf) {
            HiveConf hiveConf = new HiveConf(conf, this.getClass());
            SessionState.start(hiveConf);
            this.driver = DriverFactory.newDriver(hiveConf);
        }

        void close() {
            if (this.driver != null) {
                HiveStrictManagedMigration.runAndLogErrors(() -> this.driver.close());
                HiveStrictManagedMigration.runAndLogErrors(() -> this.driver.destroy());
                this.driver = null;
                HiveStrictManagedMigration.runAndLogErrors(() -> SessionState.get().close());
            }
        }
    }

    static class RunOptions {
        String dbRegex;
        String tableRegex;
        String oldWarehouseRoot;
        TableMigrationOption migrationOption;
        boolean shouldModifyManagedTableLocation;
        boolean shouldModifyManagedTableOwner;
        boolean shouldModifyManagedTablePermissions;
        boolean dryRun;

        public RunOptions(String dbRegex, String tableRegex, String oldWarehouseRoot, TableMigrationOption migrationOption, boolean shouldModifyManagedTableLocation, boolean shouldModifyManagedTableOwner, boolean shouldModifyManagedTablePermissions, boolean dryRun) {
            this.dbRegex = dbRegex;
            this.tableRegex = tableRegex;
            this.oldWarehouseRoot = oldWarehouseRoot;
            this.migrationOption = migrationOption;
            this.shouldModifyManagedTableLocation = shouldModifyManagedTableLocation;
            this.shouldModifyManagedTableOwner = shouldModifyManagedTableOwner;
            this.shouldModifyManagedTablePermissions = shouldModifyManagedTablePermissions;
            this.dryRun = dryRun;
        }
    }

    static enum TableMigrationOption {
        NONE,
        VALIDATE,
        AUTOMATIC,
        EXTERNAL,
        MANAGED;

    }
}

