/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.rcfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class RCFileMapReduceOutputFormat
extends FileOutputFormat<WritableComparable<?>, BytesRefArrayWritable> {
    public static void setColumnNumber(Configuration conf, int columnNum) {
        assert (columnNum > 0);
        RCFileOutputFormat.setColumnNumber(conf, columnNum);
    }

    public RecordWriter<WritableComparable<?>, BytesRefArrayWritable> getRecordWriter(TaskAttemptContext task) throws IOException, InterruptedException {
        FileOutputCommitter committer = (FileOutputCommitter)this.getOutputCommitter(task);
        Path outputPath = committer.getWorkPath();
        FileSystem fs = outputPath.getFileSystem(task.getConfiguration());
        if (!fs.exists(outputPath)) {
            fs.mkdirs(outputPath);
        }
        Path file = this.getDefaultWorkFile(task, "");
        CompressionCodec codec = null;
        if (RCFileMapReduceOutputFormat.getCompressOutput((JobContext)task)) {
            Class codecClass = RCFileMapReduceOutputFormat.getOutputCompressorClass((JobContext)task, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)task.getConfiguration());
        }
        final RCFile.Writer out = new RCFile.Writer(fs, task.getConfiguration(), file, (Progressable)task, codec);
        return new RecordWriter<WritableComparable<?>, BytesRefArrayWritable>(){

            public void write(WritableComparable<?> key, BytesRefArrayWritable value) throws IOException {
                out.append(value);
            }

            public void close(TaskAttemptContext task) throws IOException, InterruptedException {
                out.close();
            }
        };
    }
}

