/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcReaderOptions {
    private static final boolean DEFAULT_BLOOM_FILTERS_ENABLED = false;
    private static final DataSize DEFAULT_MAX_MERGE_DISTANCE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_TINY_STRIPE_THRESHOLD = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_STREAM_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BLOCK_SIZE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final boolean DEFAULT_LAZY_READ_SMALL_RANGES = true;
    private static final boolean DEFAULT_NESTED_LAZY = true;
    private final boolean bloomFiltersEnabled;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final DataSize tinyStripeThreshold;
    private final DataSize streamBufferSize;
    private final DataSize maxBlockSize;
    private final boolean lazyReadSmallRanges;
    private final boolean nestedLazy;

    public OrcReaderOptions() {
        this.bloomFiltersEnabled = false;
        this.maxMergeDistance = DEFAULT_MAX_MERGE_DISTANCE;
        this.maxBufferSize = DEFAULT_MAX_BUFFER_SIZE;
        this.tinyStripeThreshold = DEFAULT_TINY_STRIPE_THRESHOLD;
        this.streamBufferSize = DEFAULT_STREAM_BUFFER_SIZE;
        this.maxBlockSize = DEFAULT_MAX_BLOCK_SIZE;
        this.lazyReadSmallRanges = true;
        this.nestedLazy = true;
    }

    private OrcReaderOptions(boolean bloomFiltersEnabled, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize tinyStripeThreshold, DataSize streamBufferSize, DataSize maxBlockSize, boolean lazyReadSmallRanges, boolean nestedLazy) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.lazyReadSmallRanges = Objects.requireNonNull(Boolean.valueOf(lazyReadSmallRanges), "lazyReadSmallRanges is null");
        this.bloomFiltersEnabled = bloomFiltersEnabled;
        this.nestedLazy = nestedLazy;
    }

    public boolean isBloomFiltersEnabled() {
        return this.bloomFiltersEnabled;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public DataSize getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public boolean isLazyReadSmallRanges() {
        return this.lazyReadSmallRanges;
    }

    public boolean isNestedLazy() {
        return this.nestedLazy;
    }

    public OrcReaderOptions withBloomFiltersEnabled(boolean bloomFiltersEnabled) {
        return new OrcReaderOptions(bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    public OrcReaderOptions withMaxMergeDistance(DataSize maxMergeDistance) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    public OrcReaderOptions withMaxBufferSize(DataSize maxBufferSize) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    public OrcReaderOptions withTinyStripeThreshold(DataSize tinyStripeThreshold) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    public OrcReaderOptions withStreamBufferSize(DataSize streamBufferSize) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    public OrcReaderOptions withMaxReadBlockSize(DataSize maxBlockSize) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, maxBlockSize, this.lazyReadSmallRanges, this.nestedLazy);
    }

    @Deprecated
    public OrcReaderOptions withLazyReadSmallRanges(boolean lazyReadSmallRanges) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, lazyReadSmallRanges, this.nestedLazy);
    }

    @Deprecated
    public OrcReaderOptions withNestedLazy(boolean nestedLazy) {
        return new OrcReaderOptions(this.bloomFiltersEnabled, this.maxMergeDistance, this.maxBufferSize, this.tinyStripeThreshold, this.streamBufferSize, this.maxBlockSize, this.lazyReadSmallRanges, nestedLazy);
    }
}

