/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.Throwables;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;

class ValidationHash {
    private static final long NULL_HASH_CODE = 7944063686788161739L;
    private static final MethodHandle MAP_HASH;
    private static final MethodHandle ARRAY_HASH;
    private static final MethodHandle ROW_HASH;
    private static final MethodHandle TIMESTAMP_HASH;
    private static final TypeOperators VALIDATION_TYPE_OPERATORS_CACHE;
    private final MethodHandle hashCodeOperator;

    public static ValidationHash createValidationHash(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (type.getTypeSignature().getBase().equals("map")) {
            ValidationHash keyHash = ValidationHash.createValidationHash((Type)type.getTypeParameters().get(0));
            ValidationHash valueHash = ValidationHash.createValidationHash((Type)type.getTypeParameters().get(1));
            return new ValidationHash(MAP_HASH.bindTo(type).bindTo(keyHash).bindTo(valueHash));
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            ValidationHash elementHash = ValidationHash.createValidationHash((Type)type.getTypeParameters().get(0));
            return new ValidationHash(ARRAY_HASH.bindTo(type).bindTo(elementHash));
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            ValidationHash[] fieldHashes = (ValidationHash[])type.getTypeParameters().stream().map(ValidationHash::createValidationHash).toArray(ValidationHash[]::new);
            return new ValidationHash(ROW_HASH.bindTo(type).bindTo(fieldHashes));
        }
        if (type.getTypeSignature().getBase().equals("timestamp")) {
            return new ValidationHash(TIMESTAMP_HASH);
        }
        return new ValidationHash(VALIDATION_TYPE_OPERATORS_CACHE.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})));
    }

    private ValidationHash(MethodHandle hashCodeOperator) {
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
    }

    public long hash(Block block, int position) {
        if (block.isNull(position)) {
            return 7944063686788161739L;
        }
        try {
            return this.hashCodeOperator.invokeExact(block, position);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static long mapSkipNullKeysHash(Type type, ValidationHash keyHash, ValidationHash valueHash, Block block, int position) {
        Block mapBlock = (Block)type.getObject(block, position);
        long hash = 0L;
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            if (mapBlock.isNull(i)) continue;
            hash += keyHash.hash(mapBlock, i) ^ valueHash.hash(mapBlock, i + 1);
        }
        return hash;
    }

    private static long arrayHash(Type type, ValidationHash elementHash, Block block, int position) {
        Block array = (Block)type.getObject(block, position);
        long hash = 0L;
        for (int i = 0; i < array.getPositionCount(); ++i) {
            hash = 31L * hash + elementHash.hash(array, i);
        }
        return hash;
    }

    private static long rowHash(Type type, ValidationHash[] fieldHashes, Block block, int position) {
        Block row = (Block)type.getObject(block, position);
        long hash = 0L;
        for (int i = 0; i < row.getPositionCount(); ++i) {
            hash = 31L * hash + fieldHashes[i].hash(row, i);
        }
        return hash;
    }

    private static long timestampHash(Block block, int position) {
        long millis = TimestampType.TIMESTAMP_MILLIS.getLong(block, position);
        if (millis > -1000L && millis < 0L) {
            millis += 1000L;
        }
        return AbstractLongType.hash((long)millis);
    }

    static {
        try {
            MAP_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "mapSkipNullKeysHash", MethodType.methodType(Long.TYPE, Type.class, ValidationHash.class, ValidationHash.class, Block.class, Integer.TYPE));
            ARRAY_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "arrayHash", MethodType.methodType(Long.TYPE, Type.class, ValidationHash.class, Block.class, Integer.TYPE));
            ROW_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "rowHash", MethodType.methodType(Long.TYPE, Type.class, ValidationHash[].class, Block.class, Integer.TYPE));
            TIMESTAMP_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "timestampHash", MethodType.methodType(Long.TYPE, Block.class, Integer.TYPE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        VALIDATION_TYPE_OPERATORS_CACHE = new TypeOperators();
    }
}

