/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.orc.metadata.statistics.RangeStatistics;
import io.prestosql.orc.metadata.statistics.StatisticsHasher;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TimestampStatistics
implements RangeStatistics<Long>,
StatisticsHasher.Hashable {
    public static final long TIMESTAMP_VALUE_BYTES = 9L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampStatistics.class).instanceSize();
    private final boolean hasMinimum;
    private final boolean hasMaximum;
    private final long minimum;
    private final long maximum;

    public TimestampStatistics(Long minimum, Long maximum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.hasMinimum = minimum != null;
        this.minimum = this.hasMinimum ? minimum : 0L;
        this.hasMaximum = maximum != null;
        this.maximum = this.hasMaximum ? maximum : 0L;
    }

    @Override
    public Long getMin() {
        return this.hasMinimum ? Long.valueOf(this.minimum) : null;
    }

    @Override
    public Long getMax() {
        return this.hasMaximum ? Long.valueOf(this.maximum) : null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampStatistics that = (TimestampStatistics)o;
        return Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getMax(), that.getMax());
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.getMin()).add("max", (Object)this.getMax()).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalLong(this.hasMinimum, this.minimum).putOptionalLong(this.hasMaximum, this.maximum);
    }
}

