/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ColumnReaders;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class StructColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructColumnReader.class).instanceSize();
    private final OrcColumn column;
    private final OrcBlockFactory blockFactory;
    private final Map<String, ColumnReader> structFields;
    private final RowType type;
    private final ImmutableList<String> fieldNames;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;

    StructColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout readLayout, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, RowType.class::isInstance);
        this.type = (RowType)type;
        this.column = Objects.requireNonNull(column, "column is null");
        this.blockFactory = Objects.requireNonNull(blockFactory, "blockFactory is null");
        Map nestedColumns = (Map)column.getNestedColumns().stream().collect(ImmutableMap.toImmutableMap(stream -> stream.getColumnName().toLowerCase(Locale.ENGLISH), stream -> stream));
        ImmutableList.Builder fieldNames = ImmutableList.builder();
        ImmutableMap.Builder structFields = ImmutableMap.builder();
        for (RowType.Field field : this.type.getFields()) {
            OrcReader.ProjectedLayout fieldLayout;
            String fieldName = ((String)field.getName().orElseThrow(() -> new IllegalArgumentException("ROW type does not have field names declared: " + type))).toLowerCase(Locale.ENGLISH);
            fieldNames.add((Object)fieldName);
            OrcColumn fieldStream = (OrcColumn)nestedColumns.get(fieldName);
            if (fieldStream == null || (fieldLayout = readLayout.getFieldLayout(fieldName)) == null) continue;
            structFields.put((Object)fieldName, (Object)ColumnReaders.createColumnReader(field.getType(), fieldStream, fieldLayout, systemMemoryContext, blockFactory));
        }
        this.fieldNames = fieldNames.build();
        this.structFields = structFields.build();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block[] blocks;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            for (ColumnReader structField : this.structFields.values()) {
                structField.prepareNextRead(this.readOffset);
            }
        }
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            blocks = this.getBlocksForType(this.nextBatchSize);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                blocks = this.getBlocksForType(this.nextBatchSize - nullValues);
            } else {
                List typeParameters = this.type.getTypeParameters();
                blocks = new Block[typeParameters.size()];
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i] = ((Type)typeParameters.get(i)).createBlockBuilder(null, 0).build();
                }
            }
        }
        Verify.verify((Arrays.stream(blocks).mapToInt(Block::getPositionCount).distinct().count() == 1L ? 1 : 0) != 0);
        Block rowBlock = RowBlock.fromFieldBlocks((int)this.nextBatchSize, Optional.ofNullable(nullVector), (Block[])blocks);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return rowBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader structField : this.structFields.values()) {
            structField.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader structField : this.structFields.values()) {
            structField.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    private Block[] getBlocksForType(int positionCount) {
        Block[] blocks = new Block[this.fieldNames.size()];
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String fieldName = (String)this.fieldNames.get(i);
            ColumnReader columnReader = this.structFields.get(fieldName);
            if (columnReader != null) {
                columnReader.prepareNextRead(positionCount);
                blocks[i] = this.blockFactory.createBlock(positionCount, columnReader::readBlock, true);
                continue;
            }
            blocks[i] = RunLengthEncodedBlock.create((Type)((RowType.Field)this.type.getFields().get(i)).getType(), null, (int)positionCount);
        }
        return blocks;
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            for (ColumnReader structField : this.structFields.values()) {
                closer.register(structField::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (ColumnReader structField : this.structFields.values()) {
            retainedSizeInBytes += structField.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }
}

