/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.prestosql.orc.checkpoint.ByteArrayStreamCheckpoint;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;
import java.io.IOException;
import java.util.Objects;

public class ByteArrayInputStream
implements ValueInputStream<ByteArrayStreamCheckpoint> {
    private final OrcInputStream inputStream;

    public ByteArrayInputStream(OrcInputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
    }

    public byte[] next(int length) throws IOException {
        byte[] data = new byte[length];
        this.next(data, 0, length);
        return data;
    }

    public void next(byte[] data, int offset, int length) throws IOException {
        this.inputStream.readFully(data, offset, length);
    }

    @Override
    public void seekToCheckpoint(ByteArrayStreamCheckpoint checkpoint) throws IOException {
        this.inputStream.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long skipSize) throws IOException {
        this.inputStream.skipFully(skipSize);
    }
}

