/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.checkpoint.DecimalStreamCheckpoint;
import io.prestosql.orc.checkpoint.InputStreamCheckpoint;
import io.prestosql.orc.stream.OrcChunkLoader;
import io.prestosql.orc.stream.ValueInputStream;
import java.io.IOException;

public class DecimalInputStream
implements ValueInputStream<DecimalStreamCheckpoint> {
    private static final long SIGN_LONG_MASK = Long.MIN_VALUE;
    private static final long LONG_MASK = -9187201950435737472L;
    private static final int INT_MASK = -2139062144;
    private final OrcChunkLoader chunkLoader;
    private Slice block = Slices.EMPTY_SLICE;
    private int blockOffset;
    private long lastCheckpoint;

    public DecimalInputStream(OrcChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    @Override
    public void seekToCheckpoint(DecimalStreamCheckpoint checkpoint) throws IOException {
        int blockOffset;
        long newCheckpoint = checkpoint.getInputStreamCheckpoint();
        if (this.block.length() > 0 && InputStreamCheckpoint.decodeCompressedBlockOffset(newCheckpoint) == InputStreamCheckpoint.decodeCompressedBlockOffset(this.lastCheckpoint) && (blockOffset = InputStreamCheckpoint.decodeDecompressedOffset(newCheckpoint) - InputStreamCheckpoint.decodeDecompressedOffset(this.lastCheckpoint)) >= 0 && blockOffset < this.block.length()) {
            this.blockOffset = blockOffset;
            return;
        }
        this.chunkLoader.seekToCheckpoint(newCheckpoint);
        this.lastCheckpoint = newCheckpoint;
        this.block = Slices.EMPTY_SLICE;
        this.blockOffset = 0;
    }

    public void nextLongDecimal(long[] result, int batchSize) throws IOException {
        Verify.verify((result.length >= batchSize * 2 ? 1 : 0) != 0);
        int count = 0;
        while (count < batchSize) {
            if (this.blockOffset == this.block.length()) {
                this.advance();
            }
            while (this.blockOffset <= this.block.length() - 20) {
                long middle = 0L;
                int high = 0;
                long current = this.block.getLong(this.blockOffset);
                int zeros = Long.numberOfTrailingZeros((current ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L);
                int end = (zeros + 1) / 8;
                this.blockOffset += end;
                boolean negative = (current & 1L) == 1L;
                long low = (current & 0x7F00000000000000L) >>> 7;
                low |= (current & 0x7F000000000000L) >>> 6;
                low |= (current & 0x7F0000000000L) >>> 5;
                low |= (current & 0x7F00000000L) >>> 4;
                low |= (current & 0x7F000000L) >>> 3;
                low |= (current & 0x7F0000L) >>> 2;
                low |= (current & 0x7F00L) >>> 1;
                low |= (current & 0x7FL) >>> 0;
                low &= (1L << end * 7) - 1L;
                if (zeros == 64) {
                    current = this.block.getLong(this.blockOffset);
                    zeros = Long.numberOfTrailingZeros((current ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L);
                    end = (zeros + 1) / 8;
                    this.blockOffset += end;
                    middle = (current & 0x7F00000000000000L) >>> 7;
                    middle |= (current & 0x7F000000000000L) >>> 6;
                    middle |= (current & 0x7F0000000000L) >>> 5;
                    middle |= (current & 0x7F00000000L) >>> 4;
                    middle |= (current & 0x7F000000L) >>> 3;
                    middle |= (current & 0x7F0000L) >>> 2;
                    middle |= (current & 0x7F00L) >>> 1;
                    middle |= (current & 0x7FL) >>> 0;
                    middle &= (1L << end * 7) - 1L;
                    if (zeros == 64) {
                        int last = this.block.getInt(this.blockOffset);
                        zeros = Integer.numberOfTrailingZeros(~last & 0x80808080);
                        end = (zeros + 1) / 8;
                        this.blockOffset += end;
                        high = (last & 0x7F0000) >>> 2;
                        high |= (last & 0x7F00) >>> 1;
                        high |= (last & 0x7F) >>> 0;
                        if (end == 4 || (high &= (1 << end * 7) - 1) > 65535) {
                            throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal exceeds 128 bits");
                        }
                    }
                }
                DecimalInputStream.emitLongDecimal(result, count, low, middle, high, negative);
                if (++count != batchSize) continue;
                return;
            }
            count = this.decodeLongDecimalTail(result, count, batchSize);
        }
    }

    private int decodeLongDecimalTail(long[] result, int count, int batchSize) throws IOException {
        boolean negative = false;
        long low = 0L;
        long middle = 0L;
        int high = 0;
        boolean last = false;
        if (this.blockOffset == this.block.length()) {
            this.advance();
        }
        int offset = 0;
        while (true) {
            long value = this.block.getByte(this.blockOffset);
            ++this.blockOffset;
            if (offset == 0) {
                negative = (value & 1L) == 1L;
                low |= value & 0x7FL;
            } else if (offset < 8) {
                low |= (value & 0x7FL) << offset * 7;
            } else if (offset < 16) {
                middle |= (value & 0x7FL) << (offset - 8) * 7;
            } else if (offset < 19) {
                high = (int)((long)high | (value & 0x7FL) << (offset - 16) * 7);
            } else {
                throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal exceeds 128 bits");
            }
            ++offset;
            if ((value & 0x80L) == 0L) {
                if (high > 65535) {
                    throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal exceeds 128 bits");
                }
                DecimalInputStream.emitLongDecimal(result, count, low, middle, high, negative);
                low = 0L;
                middle = 0L;
                high = 0;
                offset = 0;
                if (this.blockOffset != this.block.length() && !last && ++count != batchSize) continue;
                break;
            }
            if (this.blockOffset != this.block.length()) continue;
            last = true;
            this.advance();
        }
        return count;
    }

    private static void emitLongDecimal(long[] result, int offset, long low, long middle, long high, boolean negative) {
        long lower = low >>> 1 | middle << 55;
        long upper = middle >>> 9 | high << 47;
        if (negative && lower == -1L) {
            lower = 0L;
            ++upper;
        }
        result[2 * offset] = ++lower;
        result[2 * offset + 1] = upper | (negative ? Long.MIN_VALUE : 0L);
    }

    public void nextShortDecimal(long[] result, int batchSize) throws IOException {
        Verify.verify((result.length >= batchSize ? 1 : 0) != 0);
        int count = 0;
        while (count < batchSize) {
            if (this.blockOffset == this.block.length()) {
                this.advance();
            }
            while (this.blockOffset <= this.block.length() - 12) {
                int high = 0;
                long current = this.block.getLong(this.blockOffset);
                int zeros = Long.numberOfTrailingZeros((current ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L);
                int end = (zeros + 1) / 8;
                this.blockOffset += end;
                long low = (current & 0x7F00000000000000L) >>> 7;
                low |= (current & 0x7F000000000000L) >>> 6;
                low |= (current & 0x7F0000000000L) >>> 5;
                low |= (current & 0x7F00000000L) >>> 4;
                low |= (current & 0x7F000000L) >>> 3;
                low |= (current & 0x7F0000L) >>> 2;
                low |= (current & 0x7F00L) >>> 1;
                low |= (current & 0x7FL) >>> 0;
                low &= (1L << end * 7) - 1L;
                if (zeros == 64) {
                    int last = this.block.getInt(this.blockOffset);
                    zeros = Integer.numberOfTrailingZeros(~last & 0x80808080);
                    end = (zeros + 1) / 8;
                    this.blockOffset += end;
                    high = (last & 0x7F00) >>> 1;
                    high |= (last & 0x7F) >>> 0;
                    if (end >= 3 || (high &= (1 << end * 7) - 1) > 255) {
                        throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal does not fit long (invalid table schema?)");
                    }
                }
                DecimalInputStream.emitShortDecimal(result, count, low, high);
                if (++count != batchSize) continue;
                return;
            }
            count = this.decodeShortDecimalTail(result, count, batchSize);
        }
    }

    private int decodeShortDecimalTail(long[] result, int count, int batchSize) throws IOException {
        long low = 0L;
        long high = 0L;
        boolean last = false;
        int offset = 0;
        if (this.blockOffset == this.block.length()) {
            this.advance();
        }
        while (true) {
            long value = this.block.getByte(this.blockOffset);
            ++this.blockOffset;
            if (offset == 0) {
                low |= value & 0x7FL;
            } else if (offset < 8) {
                low |= (value & 0x7FL) << offset * 7;
            } else if (offset < 11) {
                high |= (value & 0x7FL) << (offset - 8) * 7;
            } else {
                throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal does not fit long (invalid table schema?)");
            }
            ++offset;
            if ((value & 0x80L) == 0L) {
                if (high > 255L) {
                    throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Decimal does not fit long (invalid table schema?)");
                }
                DecimalInputStream.emitShortDecimal(result, count, low, high);
                low = 0L;
                high = 0L;
                offset = 0;
                if (this.blockOffset != this.block.length() && !last && ++count != batchSize) continue;
                break;
            }
            if (this.blockOffset != this.block.length()) continue;
            last = true;
            this.advance();
        }
        return count;
    }

    private static void emitShortDecimal(long[] result, int offset, long low, long high) {
        boolean negative = (low & 1L) == 1L;
        long value = low >>> 1 | high << 55;
        if (negative) {
            ++value;
            value = -value;
        }
        result[offset] = value;
    }

    @Override
    public void skip(long items) throws IOException {
        if (items == 0L) {
            return;
        }
        if (this.blockOffset == this.block.length()) {
            this.advance();
        }
        int count = 0;
        while (true) {
            long current;
            int increment;
            if (this.blockOffset <= this.block.length() - 8 && (long)(count + (increment = Long.bitCount(((current = this.block.getLong(this.blockOffset)) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L))) < items) {
                count += increment;
                this.blockOffset += 8;
                continue;
            }
            while (this.blockOffset < this.block.length()) {
                byte current2 = this.block.getByte(this.blockOffset);
                ++this.blockOffset;
                if ((current2 & 0x80) != 0 || (long)(++count) != items) continue;
                return;
            }
            this.advance();
        }
    }

    private void advance() throws IOException {
        this.block = this.chunkLoader.nextChunk();
        this.lastCheckpoint = this.chunkLoader.getLastCheckpoint();
        this.blockOffset = 0;
    }
}

