/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.OrcOutputBuffer;
import io.prestosql.orc.checkpoint.FloatStreamCheckpoint;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.stream.StreamDataOutput;
import io.prestosql.orc.stream.ValueOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class FloatOutputStream
implements ValueOutputStream<FloatStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FloatOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<FloatStreamCheckpoint> checkpoints = new ArrayList<FloatStreamCheckpoint>();
    private boolean closed;

    public FloatOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeFloat(float value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeFloat(value);
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new FloatStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<FloatStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(OrcColumnId columnId) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(columnId, Stream.StreamKind.DATA, Math.toIntExact(this.buffer.getOutputDataSize()), false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

