/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.prestosql.orc.checkpoint.BooleanStreamCheckpoint;
import io.prestosql.orc.checkpoint.LongStreamCheckpoint;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.CompressedMetadataWriter;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.RowGroupIndex;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.stream.LongOutputStream;
import io.prestosql.orc.stream.PresentOutputStream;
import io.prestosql.orc.stream.StreamDataOutput;
import io.prestosql.orc.writer.ColumnWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class MapColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapColumnWriter.class).instanceSize();
    private final OrcColumnId columnId;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream lengthStream;
    private final PresentOutputStream presentStream;
    private final ColumnWriter keyWriter;
    private final ColumnWriter valueWriter;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private int nonNullValueCount;
    private boolean closed;

    public MapColumnWriter(OrcColumnId columnId, CompressionKind compression, int bufferSize, ColumnWriter keyWriter, ColumnWriter valueWriter) {
        this.columnId = Objects.requireNonNull(columnId, "columnId is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.keyWriter = Objects.requireNonNull(keyWriter, "keyWriter is null");
        this.valueWriter = Objects.requireNonNull(valueWriter, "valueWriter is null");
        this.lengthStream = LongOutputStream.createLengthOutputStream(compression, bufferSize);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
    }

    @Override
    public List<ColumnWriter> getNestedColumnWriters() {
        return ImmutableList.builder().add((Object)this.keyWriter).addAll(this.keyWriter.getNestedColumnWriters()).add((Object)this.valueWriter).addAll(this.valueWriter.getNestedColumnWriters()).build();
    }

    @Override
    public Map<OrcColumnId, ColumnEncoding> getColumnEncodings() {
        ImmutableMap.Builder encodings = ImmutableMap.builder();
        encodings.put((Object)this.columnId, (Object)this.columnEncoding);
        encodings.putAll(this.keyWriter.getColumnEncodings());
        encodings.putAll(this.valueWriter.getColumnEncodings());
        return encodings.build();
    }

    @Override
    public void beginRowGroup() {
        this.lengthStream.recordCheckpoint();
        this.presentStream.recordCheckpoint();
        this.keyWriter.beginRowGroup();
        this.valueWriter.beginRowGroup();
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        this.writeColumnarMap(columnarMap);
    }

    private void writeColumnarMap(ColumnarMap columnarMap) {
        for (int position = 0; position < columnarMap.getPositionCount(); ++position) {
            boolean present = !columnarMap.isNull(position);
            this.presentStream.writeBoolean(present);
            if (!present) continue;
            ++this.nonNullValueCount;
            this.lengthStream.writeLong(columnarMap.getEntryCount(position));
        }
        Block keysBlock = columnarMap.getKeysBlock();
        if (keysBlock.getPositionCount() > 0) {
            this.keyWriter.writeBlock(keysBlock);
            this.valueWriter.writeBlock(columnarMap.getValuesBlock());
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = new ColumnStatistics(Long.valueOf(this.nonNullValueCount), 0L, null, null, null, null, null, null, null, null, null);
        this.rowGroupColumnStatistics.add(statistics);
        this.nonNullValueCount = 0;
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.columnId, (Object)statistics);
        columnStatistics.putAll(this.keyWriter.finishRowGroup());
        columnStatistics.putAll(this.valueWriter.finishRowGroup());
        return columnStatistics.build();
    }

    @Override
    public void close() {
        this.closed = true;
        this.keyWriter.close();
        this.valueWriter.close();
        this.lengthStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.columnId, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
        columnStatistics.putAll(this.keyWriter.getColumnStripeStatistics());
        columnStatistics.putAll(this.valueWriter.getColumnStripeStatistics());
        return columnStatistics.build();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List lengthCheckpoints = this.lengthStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            LongStreamCheckpoint lengthCheckpoint = (LongStreamCheckpoint)lengthCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = MapColumnWriter.createArrayColumnPositionList(this.compressed, lengthCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.columnId, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        ImmutableList.Builder indexStreams = ImmutableList.builder();
        indexStreams.add((Object)new StreamDataOutput(slice, stream));
        indexStreams.addAll(this.keyWriter.getIndexStreams(metadataWriter));
        indexStreams.addAll(this.keyWriter.getBloomFilters(metadataWriter));
        indexStreams.addAll(this.valueWriter.getIndexStreams(metadataWriter));
        indexStreams.addAll(this.valueWriter.getBloomFilters(metadataWriter));
        return indexStreams.build();
    }

    private static List<Integer> createArrayColumnPositionList(boolean compressed, LongStreamCheckpoint lengthCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(lengthCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getBloomFilters(CompressedMetadataWriter metadataWriter) throws IOException {
        return ImmutableList.of();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.columnId).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.lengthStream.getStreamDataOutput(this.columnId));
        outputDataStreams.addAll(this.keyWriter.getDataStreams());
        outputDataStreams.addAll(this.valueWriter.getDataStreams());
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.lengthStream.getBufferedBytes() + this.presentStream.getBufferedBytes() + this.keyWriter.getBufferedBytes() + this.valueWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.lengthStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.keyWriter.getRetainedBytes() + this.valueWriter.getRetainedBytes();
        for (ColumnStatistics statistics : this.rowGroupColumnStatistics) {
            retainedBytes += statistics.getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.lengthStream.reset();
        this.presentStream.reset();
        this.keyWriter.reset();
        this.valueWriter.reset();
        this.rowGroupColumnStatistics.clear();
        this.nonNullValueCount = 0;
    }
}

