/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;

public class RaptorBucketFunction
implements BucketFunction {
    private final HashFunction[] functions;
    private final int bucketCount;

    public RaptorBucketFunction(int bucketCount, List<Type> types) {
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be at least one");
        this.bucketCount = bucketCount;
        this.functions = (HashFunction[])types.stream().map(RaptorBucketFunction::getHashFunction).toArray(HashFunction[]::new);
    }

    public int getBucket(Page page, int position) {
        long hash = 0L;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            long value = this.functions[i].hash(block, position);
            hash = hash * 31L + value;
        }
        int value = (int)(hash & Integer.MAX_VALUE);
        return value % this.bucketCount;
    }

    public static void validateBucketType(Type type) {
        RaptorBucketFunction.getHashFunction(type);
    }

    private static HashFunction getHashFunction(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return RaptorBucketFunction.bigintHashFunction();
        }
        if (type.equals(IntegerType.INTEGER)) {
            return RaptorBucketFunction.intHashFunction();
        }
        if (type instanceof VarcharType) {
            return RaptorBucketFunction.varcharHashFunction();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing is supported for bigint, integer and varchar, not " + type.getDisplayName());
    }

    private static HashFunction bigintHashFunction() {
        return (block, position) -> XxHash64.hash((long)BigintType.BIGINT.getLong(block, position));
    }

    private static HashFunction intHashFunction() {
        return (block, position) -> XxHash64.hash((long)IntegerType.INTEGER.getLong(block, position));
    }

    private static HashFunction varcharHashFunction() {
        return (block, position) -> XxHash64.hash((Slice)block.getSlice(position, 0, block.getSliceLength(position)));
    }

    private static interface HashFunction {
        public long hash(Block var1, int var2);
    }
}

