/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.raptor.legacy.RaptorColumnHandle;
import io.prestosql.plugin.raptor.legacy.RaptorSessionProperties;
import io.prestosql.plugin.raptor.legacy.RaptorSplit;
import io.prestosql.plugin.raptor.legacy.RaptorTableHandle;
import io.prestosql.plugin.raptor.legacy.storage.StorageManager;
import io.prestosql.plugin.raptor.legacy.util.ConcatPageSource;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final StorageManager storageManager;

    @Inject
    public RaptorPageSourceProvider(StorageManager storageManager) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        RaptorSplit raptorSplit = (RaptorSplit)split;
        RaptorTableHandle raptorTable = (RaptorTableHandle)table;
        OptionalInt bucketNumber = raptorSplit.getBucketNumber();
        TupleDomain<RaptorColumnHandle> predicate = raptorTable.getConstraint();
        OrcReaderOptions options = new OrcReaderOptions().withMaxMergeDistance(RaptorSessionProperties.getReaderMaxMergeDistance(session)).withMaxBufferSize(RaptorSessionProperties.getReaderMaxReadSize(session)).withStreamBufferSize(RaptorSessionProperties.getReaderStreamBufferSize(session)).withTinyStripeThreshold(RaptorSessionProperties.getReaderTinyStripeThreshold(session)).withLazyReadSmallRanges(RaptorSessionProperties.isReaderLazyReadSmallRanges(session));
        OptionalLong transactionId = raptorSplit.getTransactionId();
        if (raptorSplit.getShardUuids().size() == 1) {
            UUID shardUuid2 = raptorSplit.getShardUuids().iterator().next();
            return this.createPageSource(shardUuid2, bucketNumber, columns, predicate, options, transactionId);
        }
        Iterator<ConnectorPageSource> iterator = raptorSplit.getShardUuids().stream().map(shardUuid -> this.createPageSource((UUID)shardUuid, bucketNumber, columns, predicate, options, transactionId)).iterator();
        return new ConcatPageSource(iterator);
    }

    private ConnectorPageSource createPageSource(UUID shardUuid, OptionalInt bucketNumber, List<ColumnHandle> columns, TupleDomain<RaptorColumnHandle> predicate, OrcReaderOptions orcReaderOptions, OptionalLong transactionId) {
        List columnHandles = columns.stream().map(RaptorColumnHandle.class::cast).collect(Collectors.toList());
        List<Long> columnIds = columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columnHandles.stream().map(RaptorColumnHandle::getColumnType).collect(Collectors.toList());
        return this.storageManager.getPageSource(shardUuid, bucketNumber, columnIds, columnTypes, predicate, orcReaderOptions, transactionId);
    }
}

