/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;

public class RaptorSplit
implements ConnectorSplit {
    private final Set<UUID> shardUuids;
    private final OptionalInt bucketNumber;
    private final List<HostAddress> addresses;
    private final OptionalLong transactionId;

    @JsonCreator
    public RaptorSplit(@JsonProperty(value="shardUuids") Set<UUID> shardUuids, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="transactionId") OptionalLong transactionId) {
        this(shardUuids, bucketNumber, (List<HostAddress>)ImmutableList.of(), transactionId);
    }

    public RaptorSplit(UUID shardUuid, List<HostAddress> addresses, OptionalLong transactionId) {
        this((Set<UUID>)ImmutableSet.of((Object)shardUuid), OptionalInt.empty(), addresses, transactionId);
    }

    public RaptorSplit(Set<UUID> shardUuids, int bucketNumber, HostAddress address, OptionalLong transactionId) {
        this(shardUuids, OptionalInt.of(bucketNumber), (List<HostAddress>)ImmutableList.of((Object)address), transactionId);
    }

    private RaptorSplit(Set<UUID> shardUuids, OptionalInt bucketNumber, List<HostAddress> addresses, OptionalLong transactionId) {
        this.shardUuids = ImmutableSet.copyOf((Collection)Objects.requireNonNull(shardUuids, "shardUuid is null"));
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public Set<UUID> getShardUuids() {
        return this.shardUuids;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public OptionalLong getTransactionId() {
        return this.transactionId;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuids", this.shardUuids).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).add("hosts", this.addresses).omitNullValues().toString();
    }
}

