/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.backup;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.prestosql.plugin.raptor.legacy.backup.BackupStore;
import io.prestosql.plugin.raptor.legacy.backup.ForHttpBackup;
import io.prestosql.plugin.raptor.legacy.backup.HttpBackupConfig;
import io.prestosql.plugin.raptor.legacy.backup.HttpBackupStore;
import java.net.URI;
import java.util.function.Supplier;
import javax.inject.Singleton;

public class HttpBackupModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpBackupConfig.class);
        binder.bind(BackupStore.class).to(HttpBackupStore.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("backup", ForHttpBackup.class);
    }

    @Provides
    @Singleton
    @ForHttpBackup
    public Supplier<URI> createBackupUriSupplier(HttpBackupConfig config) {
        URI uri = config.getUri();
        return () -> uri;
    }
}

