/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalInt;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ColumnMetadataRow {
    private final long tableId;
    private final long columnId;
    private final String columnName;
    private final OptionalInt sortOrdinalPosition;
    private final OptionalInt bucketOrdinalPosition;

    public ColumnMetadataRow(long tableId, long columnId, String columnName, OptionalInt sortOrdinalPosition, OptionalInt bucketOrdinalPosition) {
        this.tableId = tableId;
        this.columnId = columnId;
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.sortOrdinalPosition = Objects.requireNonNull(sortOrdinalPosition, "sortOrdinalPosition is null");
        this.bucketOrdinalPosition = Objects.requireNonNull(bucketOrdinalPosition, "bucketOrdinalPosition is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getColumnId() {
        return this.columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public OptionalInt getSortOrdinalPosition() {
        return this.sortOrdinalPosition;
    }

    public OptionalInt getBucketOrdinalPosition() {
        return this.bucketOrdinalPosition;
    }

    public static class Mapper
    implements ResultSetMapper<ColumnMetadataRow> {
        public ColumnMetadataRow map(int index, ResultSet rs, StatementContext context) throws SQLException {
            return new ColumnMetadataRow(rs.getLong("table_id"), rs.getLong("column_id"), rs.getString("column_name"), DatabaseUtil.getOptionalInt(rs, "sort_ordinal_position"), DatabaseUtil.getOptionalInt(rs, "bucket_ordinal_position"));
        }
    }
}

