/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.airlift.log.Logger;
import io.prestosql.plugin.raptor.legacy.metadata.ShardDao;
import io.prestosql.plugin.raptor.legacy.metadata.ShardRecorder;
import io.prestosql.plugin.raptor.legacy.util.DaoSupplier;
import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import io.prestosql.spi.PrestoException;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DatabaseShardRecorder
implements ShardRecorder {
    private static final Logger log = Logger.get(DatabaseShardRecorder.class);
    private final ShardDao dao;

    @Inject
    public DatabaseShardRecorder(DaoSupplier<ShardDao> shardDaoSupplier) {
        this.dao = shardDaoSupplier.onDemand();
    }

    @Override
    public void recordCreatedShard(long transactionId, UUID shardUuid) {
        int maxAttempts = 5;
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                DatabaseUtil.runIgnoringConstraintViolation(() -> this.dao.insertCreatedShard(shardUuid, transactionId));
                return;
            }
            catch (PrestoException e) {
                if (attempt == maxAttempts) {
                    throw e;
                }
                log.warn((Throwable)e, "Failed to insert created shard on attempt %s, will retry", new Object[]{attempt});
                try {
                    long millis = (long)attempt * 2000L;
                    TimeUnit.MILLISECONDS.sleep(millis + ThreadLocalRandom.current().nextLong(0L, millis));
                    continue;
                }
                catch (InterruptedException ie) {
                    throw DatabaseUtil.metadataError(ie);
                }
            }
        }
    }
}

