/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class Distribution {
    private static final JsonCodec<List<String>> LIST_CODEC = JsonCodec.listJsonCodec(String.class);
    private final long id;
    private final Optional<String> name;
    private final List<Type> columnTypes;
    private final int bucketCount;

    public Distribution(long id, Optional<String> name, List<Type> columnTypes, int bucketCount) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.bucketCount = bucketCount;
    }

    public long getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public static String serializeColumnTypes(List<Type> columnTypes) {
        return LIST_CODEC.toJson(columnTypes.stream().map(type -> type.getTypeId().getId()).collect(Collectors.toList()));
    }

    public static class Mapper
    implements ResultSetMapper<Distribution> {
        private final TypeManager typeManager;

        @Inject
        public Mapper(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        public Distribution map(int index, ResultSet rs, StatementContext ctx) throws SQLException {
            List types = (List)((List)LIST_CODEC.fromJson(rs.getString("column_types"))).stream().map(TypeId::of).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
            return new Distribution(rs.getLong("distribution_id"), Optional.ofNullable(rs.getString("distribution_name")), types, rs.getInt("bucket_count"));
        }
    }
}

