/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class NodeSize {
    private final String nodeIdentifier;
    private final long sizeInBytes;

    public NodeSize(String nodeIdentifier, long sizeInBytes) {
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null");
        Preconditions.checkArgument((sizeInBytes >= 0L ? 1 : 0) != 0, (Object)"sizeInBytes must be >= 0");
        this.sizeInBytes = sizeInBytes;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSize nodeSize = (NodeSize)o;
        return this.sizeInBytes == nodeSize.sizeInBytes && Objects.equals(this.nodeIdentifier, nodeSize.nodeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIdentifier, this.sizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("sizeInBytes", this.sizeInBytes).toString();
    }

    public static class Mapper
    implements ResultSetMapper<NodeSize> {
        public NodeSize map(int index, ResultSet rs, StatementContext context) throws SQLException {
            return new NodeSize(rs.getString("node_identifier"), rs.getLong("bytes"));
        }
    }
}

