/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.prestosql.plugin.raptor.legacy.util.UuidUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ShardNodeId {
    private final UUID shardUuid;
    private final int nodeId;

    public ShardNodeId(UUID shardUuid, int nodeId) {
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.nodeId = nodeId;
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardNodeId that = (ShardNodeId)o;
        return this.nodeId == that.nodeId && Objects.equals(this.shardUuid, that.shardUuid);
    }

    public int hashCode() {
        return Objects.hash(this.shardUuid, this.nodeId);
    }

    public String toString() {
        return this.shardUuid + ":" + this.nodeId;
    }

    public static class Mapper
    implements ResultSetMapper<ShardNodeId> {
        public ShardNodeId map(int index, ResultSet rs, StatementContext ctx) throws SQLException {
            return new ShardNodeId(UuidUtil.uuidFromBytes(rs.getBytes("shard_uuid")), rs.getInt("node_id"));
        }
    }
}

