/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage;

import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.plugin.raptor.legacy.storage.ShardRecoveryManager;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class BackupStats {
    private final DistributionStat copyToBackupBytesPerSecond = new DistributionStat();
    private final DistributionStat copyToBackupShardSizeBytes = new DistributionStat();
    private final DistributionStat copyToBackupTimeInMilliSeconds = new DistributionStat();
    private final DistributionStat queuedTimeMilliSeconds = new DistributionStat();
    private final CounterStat backupSuccess = new CounterStat();
    private final CounterStat backupFailure = new CounterStat();
    private final CounterStat backupCorruption = new CounterStat();

    public void addCopyShardDataRate(DataSize size, Duration duration) {
        DataSize rate = ShardRecoveryManager.dataRate(size, duration).succinct();
        this.copyToBackupBytesPerSecond.add(rate.toBytes());
        this.copyToBackupShardSizeBytes.add(size.toBytes());
        this.copyToBackupTimeInMilliSeconds.add(duration.toMillis());
    }

    public void addQueuedTime(Duration queuedTime) {
        this.queuedTimeMilliSeconds.add(queuedTime.toMillis());
    }

    public void incrementBackupSuccess() {
        this.backupSuccess.update(1L);
    }

    public void incrementBackupFailure() {
        this.backupFailure.update(1L);
    }

    public void incrementBackupCorruption() {
        this.backupCorruption.update(1L);
    }

    @Managed
    @Nested
    public DistributionStat getCopyToBackupBytesPerSecond() {
        return this.copyToBackupBytesPerSecond;
    }

    @Managed
    @Nested
    public DistributionStat getCopyToBackupShardSizeBytes() {
        return this.copyToBackupShardSizeBytes;
    }

    @Managed
    @Nested
    public DistributionStat getCopyToBackupTimeInMilliSeconds() {
        return this.copyToBackupTimeInMilliSeconds;
    }

    @Managed
    @Nested
    public DistributionStat getQueuedTimeMilliSeconds() {
        return this.queuedTimeMilliSeconds;
    }

    @Managed
    @Nested
    public CounterStat getBackupSuccess() {
        return this.backupSuccess;
    }

    @Managed
    @Nested
    public CounterStat getBackupFailure() {
        return this.backupFailure;
    }

    @Managed
    @Nested
    public CounterStat getBackupCorruption() {
        return this.backupCorruption;
    }
}

