/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.plugin.raptor.legacy.RaptorColumnHandle;
import io.prestosql.plugin.raptor.legacy.RaptorErrorCode;
import io.prestosql.plugin.raptor.legacy.storage.ShardRewriter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class OrcPageSource
implements UpdatablePageSource {
    private final Optional<ShardRewriter> shardRewriter;
    private final OrcRecordReader recordReader;
    private final List<ColumnAdaptation> columnAdaptations;
    private final OrcDataSource orcDataSource;
    private final BitSet rowsToDelete;
    private final AggregatedMemoryContext systemMemoryContext;
    private boolean closed;

    public OrcPageSource(Optional<ShardRewriter> shardRewriter, OrcRecordReader recordReader, List<ColumnAdaptation> columnAdaptations, OrcDataSource orcDataSource, AggregatedMemoryContext systemMemoryContext) {
        this.shardRewriter = Objects.requireNonNull(shardRewriter, "shardRewriter is null");
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.rowsToDelete = new BitSet(Math.toIntExact(recordReader.getFileRowCount()));
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.recordReader.nextPage();
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw OrcPageSource.handleException(e);
        }
        if (page == null) {
            this.close();
            return null;
        }
        long filePosition = this.recordReader.getFilePosition();
        Block[] blocks = new Block[this.columnAdaptations.size()];
        for (int i = 0; i < this.columnAdaptations.size(); ++i) {
            blocks[i] = this.columnAdaptations.get(i).block(page, filePosition);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    static PrestoException handleException(Exception exception) {
        if (exception instanceof PrestoException) {
            return (PrestoException)((Object)exception);
        }
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)exception);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columnAdaptations).toString();
    }

    public void deleteRows(Block rowIds) {
        for (int i = 0; i < rowIds.getPositionCount(); ++i) {
            long rowId = BigintType.BIGINT.getLong(rowIds, i);
            this.rowsToDelete.set(Math.toIntExact(rowId));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        Preconditions.checkState((boolean)this.shardRewriter.isPresent(), (Object)"shardRewriter is missing");
        return this.shardRewriter.get().rewrite(this.rowsToDelete);
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private static class SourceColumn
    implements ColumnAdaptation {
        private final int index;

        public SourceColumn(int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index is negative");
            this.index = index;
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return sourcePage.getBlock(this.index);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).toString();
        }
    }

    private static class BucketNumberColumn
    implements ColumnAdaptation {
        private final Block bucketNumberBlock;

        public BucketNumberColumn(int bucketNumber) {
            BlockBuilder blockBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
            IntegerType.INTEGER.writeLong(blockBuilder, (long)bucketNumber);
            this.bucketNumberBlock = blockBuilder.build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return new RunLengthEncodedBlock(this.bucketNumberBlock, sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    private static class NullColumn
    implements ColumnAdaptation {
        private final Type type;
        private final Block nullBlock;

        public NullColumn(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.nullBlock = type.createBlockBuilder(null, 1, 0).appendNull().build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return new RunLengthEncodedBlock(this.nullBlock, sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
        }
    }

    private static class RowIdColumn
    implements ColumnAdaptation {
        private RowIdColumn() {
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            int count = sourcePage.getPositionCount();
            BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(count);
            for (int i = 0; i < count; ++i) {
                BigintType.BIGINT.writeLong(builder, filePosition + (long)i);
            }
            return builder.build();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    private static class ShardUuidAdaptation
    implements ColumnAdaptation {
        private final Block shardUuidBlock;

        public ShardUuidAdaptation(UUID shardUuid) {
            Slice slice = Slices.utf8Slice((String)shardUuid.toString());
            BlockBuilder blockBuilder = RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE.createBlockBuilder(null, 1, slice.length());
            RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE.writeSlice(blockBuilder, slice);
            this.shardUuidBlock = blockBuilder.build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return new RunLengthEncodedBlock(this.shardUuidBlock, sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static interface ColumnAdaptation {
        public Block block(Page var1, long var2);

        public static ColumnAdaptation nullColumn(Type type) {
            return new NullColumn(type);
        }

        public static ColumnAdaptation shardUuidColumn(UUID shardUuid) {
            return new ShardUuidAdaptation(shardUuid);
        }

        public static ColumnAdaptation bucketNumberColumn(OptionalInt bucketNumber) {
            if (bucketNumber.isEmpty()) {
                return ColumnAdaptation.nullColumn((Type)IntegerType.INTEGER);
            }
            return new BucketNumberColumn(bucketNumber.getAsInt());
        }

        public static ColumnAdaptation rowIdColumn() {
            return new RowIdColumn();
        }

        public static ColumnAdaptation sourceColumn(int index) {
            return new SourceColumn(index);
        }
    }
}

