/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.plugin.raptor.legacy.RaptorErrorCode;
import io.prestosql.plugin.raptor.legacy.metadata.ColumnStats;
import io.prestosql.plugin.raptor.legacy.storage.OrcStorageManager;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public final class ShardStats {
    public static final int MAX_BINARY_INDEX_SIZE = 100;

    private ShardStats() {
    }

    public static Slice truncateIndexValue(Slice slice) {
        if (slice.length() > 100) {
            return slice.slice(0, 100);
        }
        return slice;
    }

    public static Optional<ColumnStats> computeColumnStats(OrcReader orcReader, long columnId, Type type, TypeManager typeManager) throws IOException {
        return Optional.ofNullable(ShardStats.doComputeColumnStats(orcReader, columnId, type, typeManager));
    }

    private static ColumnStats doComputeColumnStats(OrcReader orcReader, long columnId, Type type, TypeManager typeManager) throws IOException {
        OrcColumn column = ShardStats.getColumn(orcReader.getRootColumn().getNestedColumns(), columnId);
        Type columnType = OrcStorageManager.toOrcFileType(type, typeManager);
        OrcRecordReader reader = orcReader.createRecordReader((List)ImmutableList.of((Object)column), (List)ImmutableList.of((Object)columnType), OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, exception -> new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Error reading column: " + columnId, (Throwable)exception));
        if (type.equals(BooleanType.BOOLEAN)) {
            return ShardStats.indexBoolean(reader, columnId);
        }
        if (type.equals(BigintType.BIGINT) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return ShardStats.indexLong(type, reader, columnId);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return ShardStats.indexDouble(reader, columnId);
        }
        if (type instanceof VarcharType) {
            return ShardStats.indexString(type, reader, columnId);
        }
        return null;
    }

    private static OrcColumn getColumn(List<OrcColumn> columnNames, long columnId) {
        String columnName = String.valueOf(columnId);
        return columnNames.stream().filter(column -> column.getColumnName().equals(columnName)).findFirst().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Missing column ID: " + columnId));
    }

    private static ColumnStats indexBoolean(OrcRecordReader reader, long columnId) throws IOException {
        Page page;
        boolean minSet = false;
        boolean maxSet = false;
        boolean min = false;
        boolean max = false;
        while ((page = reader.nextPage()) != null) {
            Block block = page.getBlock(0).getLoadedBlock();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                boolean value = BooleanType.BOOLEAN.getBoolean(block, i);
                if (!minSet || Boolean.compare(value, min) < 0) {
                    minSet = true;
                    min = value;
                }
                if (maxSet && Boolean.compare(value, max) <= 0) continue;
                maxSet = true;
                max = value;
            }
        }
        return new ColumnStats(columnId, minSet ? Boolean.valueOf(min) : null, maxSet ? Boolean.valueOf(max) : null);
    }

    private static ColumnStats indexLong(Type type, OrcRecordReader reader, long columnId) throws IOException {
        Page page;
        boolean minSet = false;
        boolean maxSet = false;
        long min = 0L;
        long max = 0L;
        while ((page = reader.nextPage()) != null) {
            Block block = page.getBlock(0).getLoadedBlock();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                long value = type.getLong(block, i);
                if (!minSet || value < min) {
                    minSet = true;
                    min = value;
                }
                if (maxSet && value <= max) continue;
                maxSet = true;
                max = value;
            }
        }
        return new ColumnStats(columnId, minSet ? Long.valueOf(min) : null, maxSet ? Long.valueOf(max) : null);
    }

    private static ColumnStats indexDouble(OrcRecordReader reader, long columnId) throws IOException {
        Page page;
        boolean minSet = false;
        boolean maxSet = false;
        double min = 0.0;
        double max = 0.0;
        while ((page = reader.nextPage()) != null) {
            Block block = page.getBlock(0).getLoadedBlock();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                double value;
                if (block.isNull(i) || Double.isNaN(value = DoubleType.DOUBLE.getDouble(block, i))) continue;
                if (value == -0.0) {
                    value = 0.0;
                }
                if (!minSet || value < min) {
                    minSet = true;
                    min = value;
                }
                if (maxSet && !(value > max)) continue;
                maxSet = true;
                max = value;
            }
        }
        if (Double.isInfinite(min)) {
            minSet = false;
        }
        if (Double.isInfinite(max)) {
            maxSet = false;
        }
        return new ColumnStats(columnId, minSet ? Double.valueOf(min) : null, maxSet ? Double.valueOf(max) : null);
    }

    private static ColumnStats indexString(Type type, OrcRecordReader reader, long columnId) throws IOException {
        Page page;
        boolean minSet = false;
        boolean maxSet = false;
        Slice min = null;
        Slice max = null;
        while ((page = reader.nextPage()) != null) {
            Block block = page.getBlock(0).getLoadedBlock();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                Slice slice = type.getSlice(block, i);
                slice = ShardStats.truncateIndexValue(slice);
                if (!minSet || slice.compareTo(min) < 0) {
                    minSet = true;
                    min = slice;
                }
                if (maxSet && slice.compareTo(max) <= 0) continue;
                maxSet = true;
                max = slice;
            }
        }
        return new ColumnStats(columnId, minSet ? min.toStringUtf8() : null, maxSet ? max.toStringUtf8() : null);
    }
}

