/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import io.prestosql.plugin.raptor.legacy.metadata.ForMetadata;
import io.prestosql.plugin.raptor.legacy.metadata.MetadataDao;
import io.prestosql.plugin.raptor.legacy.metadata.ShardManager;
import io.prestosql.plugin.raptor.legacy.storage.organization.JobFactory;
import io.prestosql.plugin.raptor.legacy.storage.organization.OrganizationJob;
import io.prestosql.plugin.raptor.legacy.storage.organization.OrganizationSet;
import io.prestosql.plugin.raptor.legacy.storage.organization.ShardCompactor;
import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import java.util.Objects;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class OrganizationJobFactory
implements JobFactory {
    private final MetadataDao metadataDao;
    private final ShardManager shardManager;
    private final ShardCompactor compactor;

    @Inject
    public OrganizationJobFactory(@ForMetadata IDBI dbi, ShardManager shardManager, ShardCompactor compactor) {
        Objects.requireNonNull(dbi, "dbi is null");
        this.metadataDao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.compactor = Objects.requireNonNull(compactor, "compactor is null");
    }

    @Override
    public Runnable create(OrganizationSet organizationSet) {
        return new OrganizationJob(organizationSet, this.metadataDao, this.shardManager, this.compactor);
    }
}

