/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalLong;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TableOrganizationInfo {
    private final long tableId;
    private final OptionalLong lastStartTimeMillis;

    public TableOrganizationInfo(long tableId, OptionalLong lastStartTimeMillis) {
        this.tableId = tableId;
        this.lastStartTimeMillis = Objects.requireNonNull(lastStartTimeMillis, "lastStartTimeMillis is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public OptionalLong getLastStartTimeMillis() {
        return this.lastStartTimeMillis;
    }

    public static class Mapper
    implements ResultSetMapper<TableOrganizationInfo> {
        public TableOrganizationInfo map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new TableOrganizationInfo(r.getLong("table_id"), DatabaseUtil.getOptionalLong(r, "last_start_time"));
        }
    }
}

