/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.systemtables;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.util.List;

class PageListBuilder {
    private final PageBuilder pageBuilder;
    private final ImmutableList.Builder<Page> pages = ImmutableList.builder();
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.pageBuilder = new PageBuilder(types);
    }

    public List<Page> build() {
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public BlockBuilder nextBlockBuilder() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }
}

