/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.skife.jdbi.v2.ResultIterator;

public class SynchronizedResultIterator<T>
implements ResultIterator<T> {
    @GuardedBy(value="this")
    private final ResultIterator<T> iterator;
    @GuardedBy(value="this")
    private boolean closed;

    public SynchronizedResultIterator(ResultIterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public synchronized boolean hasNext() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        return this.iterator.hasNext();
    }

    public synchronized T next() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        return (T)this.iterator.next();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.iterator.close();
        }
    }
}

