/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.util;

import io.airlift.slice.XxHash64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.util.Progressable;

public final class SyncingFileSystem
extends RawLocalFileSystem {
    public SyncingFileSystem(Configuration configuration) throws IOException {
        this.initialize(this.getUri(), configuration);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(path) && !overwrite) {
            throw new IOException("file already exists: " + path);
        }
        Path parent = path.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream((OutputStream)new BufferedOutputStream(new LocalFileOutputStream(this.pathToFile(path)), bufferSize), this.statistics);
    }

    private static class LocalFileOutputStream
    extends OutputStream {
        private final byte[] oneByte = new byte[1];
        private final XxHash64 hash = new XxHash64();
        private final File file;
        private final FileOutputStream out;
        private boolean closed;

        private LocalFileOutputStream(File file) throws IOException {
            this.file = Objects.requireNonNull(file, "file is null");
            this.out = new FileOutputStream(file);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.flush();
            this.out.getFD().sync();
            this.out.close();
            try (FileInputStream in = new FileInputStream(this.file);){
                if (this.hash.hash() != XxHash64.hash((InputStream)in)) {
                    throw new IOException("File is corrupt after write");
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.hash.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.oneByte[0] = (byte)(b & 0xFF);
            this.write(this.oneByte, 0, 1);
        }
    }
}

