/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.base.security.AnySchemaPermissionsRule;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class TableAccessControlRule {
    public static final TableAccessControlRule ALLOW_ALL = new TableAccessControlRule((Set<TablePrivilege>)ImmutableSet.copyOf((Object[])TablePrivilege.values()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private final Set<TablePrivilege> privileges;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;
    private final Optional<Pattern> tableRegex;

    @JsonCreator
    public TableAccessControlRule(@JsonProperty(value="privileges") Set<TablePrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="table") Optional<Pattern> tableRegex) {
        this.privileges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privileges, "privileges is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "user is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "group is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "sourceRegex is null");
        this.tableRegex = Objects.requireNonNull(tableRegex, "tableRegex is null");
    }

    public Optional<Set<TablePrivilege>> match(String user, Set<String> groups, SchemaTableName table) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true).booleanValue() && this.schemaRegex.map(regex -> regex.matcher(table.getSchemaName()).matches()).orElse(true).booleanValue() && this.tableRegex.map(regex -> regex.matcher(table.getTableName()).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.privileges);
        }
        return Optional.empty();
    }

    Optional<AnySchemaPermissionsRule> toAnySchemaPermissionsRule() {
        if (this.privileges.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AnySchemaPermissionsRule(this.userRegex, this.groupRegex, this.schemaRegex));
    }

    Set<TablePrivilege> getPrivileges() {
        return this.privileges;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    Optional<Pattern> getSchemaRegex() {
        return this.schemaRegex;
    }

    public static enum TablePrivilege {
        SELECT,
        INSERT,
        DELETE,
        OWNERSHIP,
        GRANT_SELECT;

    }
}

