/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile;

import io.airlift.slice.Slice;
import io.prestosql.rcfile.RcFileDataSource;
import io.prestosql.rcfile.RcFileDataSourceId;
import java.util.Objects;

public class MemoryRcFileDataSource
implements RcFileDataSource {
    private final RcFileDataSourceId id;
    private final Slice data;
    private long readBytes;

    public MemoryRcFileDataSource(RcFileDataSourceId id, Slice data) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    @Override
    public RcFileDataSourceId getId() {
        return this.id;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.data.length();
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        this.data.getBytes(Math.toIntExact(position), buffer, bufferOffset, bufferLength);
        this.readBytes += (long)bufferLength;
    }

    @Override
    public void close() {
    }
}

