/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.plugin.base.type.PrestoTimestampEncoder;
import io.prestosql.plugin.base.type.PrestoTimestampEncoderFactory;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.TimestampHolder;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.TimestampType;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.function.BiFunction;
import org.joda.time.DateTimeZone;

public class TimestampEncoding
implements TextColumnEncoding {
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-M-d[ H:m[:s]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().toFormatter();
    private static final DateTimeFormatter HIVE_TIMESTAMP_PRINTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
    private final TimestampType type;
    private final Slice nullSequence;
    private final PrestoTimestampEncoder<?> prestoTimestampEncoder;
    private final StringBuilder buffer = new StringBuilder();

    public TimestampEncoding(TimestampType type, Slice nullSequence) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.nullSequence = nullSequence;
        this.prestoTimestampEncoder = PrestoTimestampEncoderFactory.createTimestampEncoder((TimestampType)this.type, (DateTimeZone)DateTimeZone.UTC);
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        BiFunction<Block, Integer, TimestampHolder> factory = TimestampHolder.getFactory(this.type);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                LocalDateTime localDateTime = factory.apply(block, position).toLocalDateTime();
                this.buffer.setLength(0);
                HIVE_TIMESTAMP_PRINTER.formatTo(localDateTime, this.buffer);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        LocalDateTime localDateTime = TimestampHolder.getFactory(this.type).apply(block, position).toLocalDateTime();
        this.buffer.setLength(0);
        HIVE_TIMESTAMP_PRINTER.formatTo(localDateTime, this.buffer);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            DecodedTimestamp decodedTimestamp = TimestampEncoding.parseTimestamp(slice, offset, length);
            this.prestoTimestampEncoder.write(decodedTimestamp, builder);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        DecodedTimestamp decodedTimestamp = TimestampEncoding.parseTimestamp(slice, offset, length);
        this.prestoTimestampEncoder.write(decodedTimestamp, builder);
    }

    private static DecodedTimestamp parseTimestamp(Slice slice, int offset, int length) {
        String timestamp = new String(slice.getBytes(offset, length), StandardCharsets.US_ASCII);
        LocalDateTime localDateTime = LocalDateTime.parse(timestamp, HIVE_TIMESTAMP_PARSER);
        return new DecodedTimestamp(localDateTime.toEpochSecond(ZoneOffset.UTC), localDateTime.getNano());
    }
}

