/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.StatsCollecting;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public final class CachingJdbcClient
implements JdbcClient {
    private final JdbcClient delegate;
    private final boolean cacheMissing;
    private final LoadingCache<JdbcIdentity, Set<String>> schemaNamesCache;
    private final LoadingCache<TableNamesCacheKey, List<SchemaTableName>> tableNamesCache;
    private final LoadingCache<TableHandleCacheKey, Optional<JdbcTableHandle>> tableHandleCache;
    private final Cache<ColumnsCacheKey, List<JdbcColumnHandle>> columnsCache;

    @Inject
    public CachingJdbcClient(@StatsCollecting JdbcClient delegate, BaseJdbcConfig config) {
        this(delegate, config.getMetadataCacheTtl(), config.isCacheMissing());
    }

    public CachingJdbcClient(JdbcClient delegate, Duration metadataCachingTtl, boolean cacheMissing) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cacheMissing = cacheMissing;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(metadataCachingTtl.toMillis(), TimeUnit.MILLISECONDS);
        this.schemaNamesCache = cacheBuilder.build(CacheLoader.from(delegate::getSchemaNames));
        this.tableNamesCache = cacheBuilder.build(CacheLoader.from(key -> delegate.getTableNames(((TableNamesCacheKey)key).identity, ((TableNamesCacheKey)key).schemaName)));
        this.tableHandleCache = cacheBuilder.build(CacheLoader.from(key -> delegate.getTableHandle(((TableHandleCacheKey)key).identity, ((TableHandleCacheKey)key).tableName)));
        this.columnsCache = cacheBuilder.build();
    }

    @Override
    public boolean schemaExists(JdbcIdentity identity, String schema) {
        return this.getSchemaNames(identity).contains(schema);
    }

    @Override
    public Set<String> getSchemaNames(JdbcIdentity identity) {
        return CachingJdbcClient.get(this.schemaNamesCache, identity);
    }

    @Override
    public List<SchemaTableName> getTableNames(JdbcIdentity identity, Optional<String> schema) {
        return CachingJdbcClient.get(this.tableNamesCache, new TableNamesCacheKey(identity, schema));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        ColumnsCacheKey key = new ColumnsCacheKey(JdbcIdentity.from(session), tableHandle.getSchemaTableName());
        List<JdbcColumnHandle> columns = (List<JdbcColumnHandle>)this.columnsCache.getIfPresent((Object)key);
        if (columns != null) {
            return columns;
        }
        columns = this.delegate.getColumns(session, tableHandle);
        this.columnsCache.put((Object)key, columns);
        return columns;
    }

    @Override
    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.delegate.toPrestoType(session, connection, typeHandle);
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.delegate.toWriteMapping(session, type);
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getSplits(session, tableHandle);
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcSplit split) throws SQLException {
        return this.delegate.getConnection(identity, split);
    }

    @Override
    public void abortReadConnection(Connection connection) throws SQLException {
        this.delegate.abortReadConnection(connection);
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        return this.delegate.buildSql(session, connection, split, table, columns);
    }

    @Override
    public boolean supportsLimit() {
        return this.delegate.supportsLimit();
    }

    @Override
    public boolean isLimitGuaranteed() {
        return this.delegate.isLimitGuaranteed();
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity identity, SchemaTableName schemaTableName) {
        TableHandleCacheKey key = new TableHandleCacheKey(identity, schemaTableName);
        Optional cachedTableHandle = (Optional)this.tableHandleCache.getIfPresent((Object)key);
        if (cachedTableHandle != null) {
            return cachedTableHandle;
        }
        Optional<JdbcTableHandle> tableHandle = this.delegate.getTableHandle(identity, schemaTableName);
        if (!tableHandle.isPresent() || this.cacheMissing) {
            this.tableHandleCache.put((Object)key, tableHandle);
        }
        return tableHandle;
    }

    @Override
    public void commitCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.delegate.commitCreateTable(identity, handle);
        this.invalidateTablesCaches();
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        return this.delegate.beginInsertTable(session, tableHandle, columns);
    }

    @Override
    public void finishInsertTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.delegate.finishInsertTable(identity, handle);
        this.invalidateTablesCaches();
    }

    @Override
    public void dropTable(JdbcIdentity identity, JdbcTableHandle jdbcTableHandle) {
        this.delegate.dropTable(identity, jdbcTableHandle);
        this.invalidateTablesCaches();
    }

    @Override
    public void rollbackCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.delegate.rollbackCreateTable(identity, handle);
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle) {
        return this.delegate.buildInsertSql(handle);
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcOutputTableHandle handle) throws SQLException {
        return this.delegate.getConnection(identity, handle);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.delegate.getPreparedStatement(connection, sql);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return this.delegate.getTableStatistics(session, handle, tupleDomain);
    }

    @Override
    public void createSchema(JdbcIdentity identity, String schemaName) {
        this.delegate.createSchema(identity, schemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public void dropSchema(JdbcIdentity identity, String schemaName) {
        this.delegate.dropSchema(identity, schemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.delegate.addColumn(session, handle, column);
        this.invalidateColumnsCache(JdbcIdentity.from(session), handle.getSchemaTableName());
    }

    @Override
    public void dropColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.delegate.dropColumn(identity, handle, column);
        this.invalidateColumnsCache(identity, handle.getSchemaTableName());
    }

    @Override
    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.delegate.renameColumn(identity, handle, jdbcColumn, newColumnName);
        this.invalidateColumnsCache(identity, handle.getSchemaTableName());
    }

    @Override
    public void renameTable(JdbcIdentity identity, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.delegate.renameTable(identity, handle, newTableName);
        this.invalidateTablesCaches();
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.delegate.createTable(session, tableMetadata);
        this.invalidateTablesCaches();
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.delegate.beginCreateTable(session, tableMetadata);
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.delegate.getSystemTable(session, tableName);
    }

    private void invalidateSchemasCache() {
        this.schemaNamesCache.invalidateAll();
    }

    private void invalidateTablesCaches() {
        this.columnsCache.invalidateAll();
        this.tableHandleCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
    }

    private void invalidateColumnsCache(JdbcIdentity identity, SchemaTableName table) {
        this.columnsCache.invalidate((Object)new ColumnsCacheKey(identity, table));
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static final class TableNamesCacheKey {
        private final JdbcIdentity identity;
        private final Optional<String> schemaName;

        private TableNamesCacheKey(JdbcIdentity identity, Optional<String> schemaName) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableNamesCacheKey that = (TableNamesCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.schemaName, that.schemaName);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.schemaName);
        }
    }

    private static final class TableHandleCacheKey {
        private final JdbcIdentity identity;
        private final SchemaTableName tableName;

        private TableHandleCacheKey(JdbcIdentity identity, SchemaTableName tableName) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableHandleCacheKey that = (TableHandleCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.tableName, that.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.tableName);
        }
    }

    private static final class ColumnsCacheKey {
        private final JdbcIdentity identity;
        private final SchemaTableName table;

        private ColumnsCacheKey(JdbcIdentity identity, SchemaTableName table) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.table = Objects.requireNonNull(table, "table is null");
        }

        public JdbcIdentity getIdentity() {
            return this.identity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnsCacheKey that = (ColumnsCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.table, that.table);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.table);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.identity).add("table", (Object)this.table).toString();
        }
    }
}

